#!/usr/bin/perl

my $numArgs = $#ARGV + 1;

if ($numArgs ne 1) {
    print "usage=specify a file to process\n";
    exit 127;
}

my $meta_file = $ARGV[0];

if ( not -f $meta_file ) {
    print "status=fail\n";
    print "note=no such file\n";
    exit 127;
}

open(FILE, $meta_file);
while (<FILE>){
    chomp;
    my ($key,$value) = split('=',$_);
    $dict{$key} = $value;
    print "$key=$value\n";
}
close(FILE);

my $data_file = $dict{'path'};

my $study_id = $dict{'study_id'};
my $subject_oid = $dict{'subject_oid'};
my $scan_id = $dict{'scan_id'};

if (! -f $data_file ){
    print "status=fail\n";
    print "note=$data_file not found\n";
    exit 127;
}


print "status=ok\n";
print "destination=$data_file\n";
print "file=$data_file\n";

print "preview_axial=$data_file.axial.png\n";
print "preview_coronal=$data_file.coronal.png\n";
print "preview_sagittal=$data_file.sagittal.png\n";

print "scan_id=$scan_id\n";
print "study_id=$study_id\n";
print "subject_oid=$subject_oid\n";

print "modality=foo\n";
print "state=foobar\n";
print "file_format=nii\n";
print "numerical_format=2\n";

print "endianness=little\n";

print "algorithm_name=pounce\n";
print "algorithm_version=1.0\n";
print "algorithm_description=moves the file\n";

print "xfov=1\n";
print "xdimension=2\n";
print "xstep=3\n";
print "xstart=4\n";
print "xorientation=RL\n";
print "xresolution=5\n";
print "yfov=1\n";
print "ydimension=2\n";
print "ystep=3\n";
print "ystart=4\n";
print "yorientation=AP\n";
print "yresolution=5\n";
print "zfov=1\n";
print "zdimension=2\n";
print "zstep=3\n";
print "zstart=4\n";
print "zorientation=SI\n";
print "zresolution=6\n";

exit 0;
