#!/bin/sh

#args!
targetuser=$1
password=$2
#pass restore_from_backups as the third argument
restore_from_backups=${3:-"NO"}
backup_dir=/home/neuroweb/backup_uploads

# handy functions:
#
# a function to display a failure message and then exit 
fail ( ) {
	echo -e $@
	exit 1
}

# "get with default" function
# this function prompts the user with a query and default reply
# it returns the user reply
getwd ( ) {
	query="$1"
	default="$2"
	echo -en "$query [$default]" | cat >&2
	read response
	if [ x$response = "x" ]; then
		response=$default
	fi
	echo $response
}

# "get yes no" function
# this function prompts the user with a query and will continue to do so
# until they reply with either "y" or "n"
getyn ( ) {
	query="$@"
	echo -en $query | cat >&2
	read response
	while [ x$response != "xy" -a x$response != "xn" ]; do
		echo -e "\n'y' or 'n' only please...\n" | cat >&2
		echo -en $query | cat >&2
		read response
	done	
	echo $response
}

# configuration 
#
# set defaults
config_h="/usr/share/doc/scponly/setup_chroot/config.h"
defaultusername="scponly"
defaulthomedirprefix="/home"
defaultwriteabledir="uploads"

osname=`uname -s | tr ' ' '_'`
# pathname to platform/OS specific setup scripts
prescript="build_extras/arch/$osname.pre.sh"
postscript="build_extras/arch/$osname.post.sh"

# the following is a list of binaries that will be staged in the target dir
BINARIES=`/bin/grep '#define PROG_' $config_h | /usr/bin/cut -f2 -d\" | /bin/grep -v ^cd$`

# we set the install path in a variable so the presetup script can overwrite it on systems
# which require it
INSTALL_PATHNAME="/usr/bin/install -c"

# attempt a best guess at required libs, we can append things in the presetup script if we need to
LDSOFOUND=0

# default to useradd, not pw
USE_PW=0

if [ x/usr/bin/ldd = x ]; then
	echo "this script requires the program ldd to determine which"
	fail "shared libraries to copy into your chrooted dir..."
fi

if [ x`uname -s` = "xOpenBSD" ]; then
	for bin in $BINARIES; do
		GREP_LIST="$GREP_LIST -e $bin"
	done
	LIB_LIST=`/usr/bin/ldd $BINARIES 2> /dev/null | /usr/bin/tr -s " " | /usr/bin/cut -f5 -d" " | /usr/bin/grep -v "^Name" | /usr/bin/grep -v $GREP_LIST | /usr/bin/sort -u`
else
	LIB_LIST=`/usr/bin/ldd $BINARIES 2> /dev/null | /usr/bin/cut -f2 -d\> | /usr/bin/cut -f1 -d\( | /bin/grep "^ " | /usr/bin/sort -u`
fi

#
#	we also need to add some form of ld.so, here are some good guesses.
#
LDSO_LIST="/lib/ld.so /libexec/ld-elf.so /libexec/ld-elf.so.1 /usr/libexec/ld.so /lib/ld-linux.so.2 /usr/libexec/ld-elf.so.1"
for lib in $LDSO_LIST; do
	if [ -f $lib ]; then
		LDSOFOUND=1;
		LIB_LIST="$LIB_LIST $lib"
	fi
done

#
#	TODO - ive since forgotten which OS this is for, it should be relocated to a presetup script
#
/bin/ls /lib/libnss_compat* > /dev/null 2>&1 
if [ $? -eq 0 ]; then
	LIB_LIST="$LIB_LIST /lib/libnss_compat*"
fi

# check that the configure options are correct for chrooted operation:

if [ xscponlyc = x ] || [ ! -f $config_h ]; then
	echo 
	echo 'your scponly build is not configured for chrooted operation.'
	echo 'please reconfigure as follows, then rebuild and reinstall:'
	echo
	echo './configure --enable-chrooted-binary (... other options)'
	echo
	exit 1
fi

if [ x/usr/sbin/useradd = x ]; then
    if [ x = x ]; then
		echo "this script requires the program useradd or pw to add your"
		fail "chrooted scponly user."
	else
  		USE_PW=1;
    fi
fi

# we need to be root
if [ `/usr/bin/id -u` != "0" ]; then
	fail "you must be root to run this script\n"
fi

#echo
#echo Next we need to set the home directory for this scponly user.
#echo please note that the users home directory MUST NOT be writeable
#echo by the scponly user.  this is important so that the scponly user
#echo cannot subvert the .ssh configuration parameters.
#echo
#echo for this reason, a writeable subdirectory will be created that
#echo the scponly user can write into.  
#echo

username_collision=`id $targetuser > /dev/null 2> /dev/null; echo $?`
if [ $username_collision -eq 0 ] ; then
	fail "the user $targetuser already exists."
fi 

targetdir="$defaulthomedirprefix/$targetuser"

writeabledir="$defaultwriteabledir"

#
#	if you would like to overwrite/extend any of the variables above, do so in the system specific
#	presetup script.  
#
if [ -f "$prescript" ]; then
#
#	this system has a pre-chroot setup script, lets run it
#
	. "$prescript"
fi

# if neither the presetup script or the best guess could find ld.so, we have to bail here
if [ $LDSOFOUND -eq 0 ]; then
	fail "i cant find your equivalent of ld.so"
fi

#
#	ACTUAL MODIFICATIONS BEGIN HERE
#

# this part shouldnt strictly be requried, but ill leave it in until im sure of it
if [ ! -d $targetdir ]; then
	$INSTALL_PATHNAME -d $targetdir
	/bin/chmod 755 $targetdir
fi

if [ ! -d $targetdir/etc ]; then
	$INSTALL_PATHNAME -d $targetdir/etc
	/bin/chown 0:0 $targetdir/etc
	/bin/chmod 755 $targetdir/etc
fi

# add all our binaries
for bin in $BINARIES; do
	$INSTALL_PATHNAME -d $targetdir/`/usr/bin/dirname $bin`
	$INSTALL_PATHNAME $bin $targetdir$bin
done

# and the libs they require
if [ "x$LIB_LIST" != "x" ]; then
	for lib in $LIB_LIST; do
		$INSTALL_PATHNAME -d $targetdir/`/usr/bin/dirname $lib`
		$INSTALL_PATHNAME $lib $targetdir/$lib
	done
fi

# /dev/null is neede inside the chroot
mkdir -p $targetdir/dev
mknod -m 666 $targetdir/dev/null c 1 3

if [ "x$USE_PW" = x0 ] ; then
    /usr/sbin/useradd -d "$targetdir" -s "/usr/sbin/scponlyc" $targetuser
    if [ $? -ne 0 ]; then
         fail "if this user exists, remove it and try again"
    fi
else
     useradd -n $targetuser -s "/usr/sbin/scponlyc" -d "$targetdir"
    if [ $? -ne 0 ]; then
         fail "if this user exists, remove it and try again"
    fi
fi 

#
#	we must ensure certain directories are root owned.
#
/bin/chown 0:0 $targetdir 
if [ -d $targetdir/.ssh ]; then
	/bin/chown 0:0 $targetdir/.ssh
fi

if [ ! -d $targetdir/$writeabledir ]; then
#	echo -e "\ncreating  $targetdir/$writeabledir directory for uploading files"
	$INSTALL_PATHNAME -o $targetuser -d $targetdir/$writeabledir
fi

if [ "restore" = "$restore_from_backups" ]; then
        rmdir $targetdir/$writeabledir
        mv $backup_dir/$targetuser/uploads $targetdir/$writeabledir
        rmdir $backup_dir/$targetuser
        back_shred=$backup_dir/$targetuser.shred
        if [ -f $back_shred ] ; then
            rm -f $back_shred
            echo "You have rescued this backup from permenant deletion..."
        fi
        echo "Your upload directory has been restored from backup"
fi


#
#	set the perms on the writeable dir so that the new user owns it
#
newuid=`/usr/bin/id -u $targetuser`
newgid=`/usr/bin/id -g neuroweb`
/bin/chown $newuid:$newgid $targetdir/$writeabledir
/bin/chmod 770 $targetdir/$writeabledir

if [ -f "$postscript" ]; then
#
#   this system has a post-chroot setup script, lets run it
#
    . "$postscript"
else
#        echo "BAD"
#
#	otherwise, revert to the old "best guess" system, which sucks
#
#	echo
#	echo "Your platform ($osname) does not have a platform specific setup script."
#	echo "This install script will attempt a best guess."
#	echo "If you perform customizations, please consider sending me your changes."
#	echo "Look to the templates in build_extras/arch."
#	echo " - joe at sublimation dot org"
#	echo
	if [ x = x ]; then
	#
	#	ok we dont have pwd_mkdb, lets improvise:
	#
		/bin/grep $targetuser /etc/passwd > $targetdir/etc/passwd

	else
	#
	#	this is for systems which do have pwd_mkdb
	#
		/bin/grep $targetuser /etc/master.passwd > $targetdir/etc/master.passwd
		 -d "$targetdir/etc" $targetdir/etc/master.passwd
		/bin/rm -rf $targetdir/etc/master.passwd $targetdir/etc/spwd.db
	fi
fi

#
#   the final step is setting the password
#
#echo "please set the password for $targetuser:"
#passwd $targetuser

#set the home dir as well in one fell swoop
echo usermod -p `mkpasswd $password` -d $targetdir//$writeabledir $targetuser
usermod -p `mkpasswd $password` -d $targetdir//$writeabledir $targetuser
echo "created user $targetuser with password $password"

#echo "if you experience a warning with winscp regarding groups, please install"
#echo "the provided hacked out fake groups program into your chroot, like so:"
#echo "cp groups $targetdir/bin/groups" 
