#!/bin/bash
backup_dir=/home/atlas/backup_uploads
shred_list=`find $backup_dir -name "*.shred"`
log_file=/home/atlas/logs/shred.log
user=$USER
if [ $1 ] ; then
        user=$1
fi
for entry in $shred_list ; do
     #figure out what to shred
     shred=`echo $entry | sed s/".shred"//`
     
     if [ ! -d $shred ] ; then #in this case, someone recovered the backup
         rm $entry
         echo "$(date +%Y_%m_%d_%M):SAVED::$user:$shred" >> $log_file
         continue;
     fi     

    ( rm $entry;
     rm -rf $shred) &> /dev/null
     if [ $? -eq 0 ] ; then
         echo "$(date +%Y_%m_%d_%M):SHRED:$user:$shred" >> $log_file
     else
         echo "$(date +%Y_%m_%d_%M):ERROR:$user:$shred" >> $log_file
     fi

done;

