#!/bin/bash

timeout=30

HOME=/home/atlas

tomcat=/home/atlas/bin/tomcat_start.sh
postgres=/home/atlas/bin/postgres_start.sh

plog=$HOME/logs/postgres.log
tlog=$HOME/logs/tomcat.log

wait_start ( ) {
        log="$1";
        stop="$2";
        echo "log: $1";
        echo "stop: $2";
        count=0
        while [ 1 ] ; do
                sleep 1;
                grep "$stop" "$1"
                if [ $? -eq 0 ] ; then
                        return 0;
                fi
                if [ $count -ge $timeout ] ; then
                        return 127;
                fi
                count=`expr $count + 1`

       done 
}


$postgres &> /dev/null &
wait_start $plog "database system is ready to accept connections"
if [ $? -eq 0 ] ; then
        info=`tail $plog`
        #gmessage -title "postgres.log" -buttons "" -timeout 3 -center "$info 
        #
        echo "..postgres started"
else
         info=`tail $plog`
        #gmessage -title "postgres.log" -buttons "" -center "$info 
        # 
        echo "...postgres failed to start correctly"
       exit 127;
fi

$tomcat &> /dev/null &
wait_start $tlog "INFO: Server startup in"
if [ $? -eq 0 ] ; then
        info=`tail $tlog`
        #gmessage -title "tomcat.log" -buttons "" -timeout 3 -center "$info 
        # 
        echo "...tomcat started"
else
         info=`tail $tlog`
        #u#essage -title "tomcat.log" -buttons "" -center "$info 
        #
        echo "...tomcat failed to start correctly"
       exit 127;
fi


pgrep tail | xargs kill

touch $HOME/running.flag
