#!/bin/bash

rm atlas.jar

webapp=/home/atlas/bin/tomcat/webapps/neuroWeb

echo -e "\nAction: deploy to $webapp..."

compile=`bin/atlas_compile`

if [ $? -ne 0 ] ; then
    echo $compile
    exit 127;
fi

echo "compile complete, building jar..."

compile=`ant`

if [ ! -f atlas.jar ] ; then
    echo $compile
    exit 127;
fi

echo "jar built, moving to webapp..."

cp atlas.jar $webapp/WEB-INF/lib/

echo "bouncing the service..."

compile=`~/stop.sh 2>&1`
if [ $? -ne 0 ] ; then
    echo $compile
    exit 127;
fi

compile=`~/start.sh 2>&1`
if [ $? -ne 0 ] ; then
    echo $compile
    exit 127;
fi


echo "...done deploy"
echo;
