#!/bin/bash

if [ ! $ATLAS_HOME ] ; then
    source environ.source
fi

if [ ! $JAVA_HOME ] ; then
    echo "Java home not set properly for complilation..."
    exit 127;
fi

CLASSPATH=`cat $ATLAS_HOME/.classpath_cache`
CLASSPATH=$CLASSPATH$ATLAS_HOME/bin
JAVAC=$JAVA_HOME/bin/javac

echo -n "compiling..."

find $ATLAS_HOME/src -name "*.java" -type f | xargs $JAVAC -cp $CLASSPATH -d $ATLAS_HOME/bin -nowarn &> /dev/null

if [ $? -ne 0 ] ; then
    echo " [  fail  ]"
    find $ATLAS_HOME/src -name "*.java" -type f | xargs $JAVAC -cp $CLASSPATH -d $ATLAS_HOME/bin
    exit 127;
else
    echo " [ ok ]"

fi
