#!/bin/bash

export ATLAS_HOME=`pwd`

if [ ! $JAVA_HOME ] ; then
    echo "Set java_home prior to deploy."
    exit 127;
fi
psql=`which psql`
if [ ! $psql ] ; then
    echo "no psql in your path!"
    exit 127;
fi

function result {
if [ $1 -ne 0 ] ; then
        echo " [ fail ]"
        exit 127;
    else
        echo " [ ok ]"
    fi
}

echo ;
echo "building atlas project"
echo "  $ATLAS_HOME"
echo ;

BIN=$ATLAS_HOME/bin
SCRIPTS=$ATLAS_HOME/scripts

echo ;
echo -n "Setting classpath..."
#echo ;

$SCRIPTS/set_classpath.sh
result $?

#echo ;
#echo "classpath: "
#echo "  `cat .classpath_cache`"
#echo ;

echo -n "making binary directory..."

if [ -d $BIN ] ; then
    rm -rf $BIN
fi
mkdir -p $BIN
result $?

echo -n "metaprogramming atlas daemon..."

echo "#!/bin/bash
source $ATLAS_HOME/conf/environ.source
exec $SCRIPTS/check_auth.sh 
" >> $BIN/atlasd
chmod +x $BIN/atlasd
result $?

echo -n "metaprogramming atlas compiler..."

echo "#!/bin/bash
source $ATLAS_HOME/conf/environ.source
exec $SCRIPTS/compile.sh 
" >> $BIN/atlas_compile
chmod +x $BIN/atlas_compile
result $?

echo -n "metaprogramming atlas upload complete..."

echo "#!/bin/bash
source $ATLAS_HOME/conf/environ.source
exec $SCRIPTS/complete.sh \$* 
" >> $BIN/atlas_complete
chmod +x $BIN/atlas_complete
result $?


echo -n "metaprogramming atlas test..."

echo "#!/bin/bash
source $ATLAS_HOME/conf/environ.source
exec $SCRIPTS/test.sh 
" >> $BIN/atlas_test
chmod +x $BIN/atlas_test
result $?


echo -n "metaprogramming atlas restart..."
echo "#!/bin/bash
source $ATLAS_HOME/conf/environ.source
exec $SCRIPTS/start.sh
" >> $BIN/atlas_restart
chmod +x $BIN/atlas_restart
result $?


echo -n "setting environment..."
rm $ATLAS_HOME/conf/environ.source
echo "
#source me
export PATH=$PATH:$BIN
export ATLAS_HOME=$ATLAS_HOME
export JAVA_HOME=$JAVA_HOME
" >> $ATLAS_HOME/conf/environ.source
source $ATLAS_HOME/conf/environ.source
result $?

#echo ;
#echo "building DB.."
#echo ;

#pushd `pwd` > /dev/null
#cd $ATLAS_HOME/sql
#./build_atlas.sh
#popd > /dev/null

$BIN/atlas_compile
if [ $? -ne 0 ] ; then
    exit 127;
fi

echo ;
echo "done deploy."
echo ;

exit 0;

