package org.mitre;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.BUnzip2;
import org.apache.tools.ant.taskdefs.GUnzip;
import org.apache.tools.ant.taskdefs.Untar;

public class Unpack {
	
	
	public static File gunzip(File target, String dest_dir){
       if (! new File(dest_dir).exists()){
			new File(dest_dir).mkdirs();
		}
		//this set up is required by the API
		Project myProject = new Project();
		GUnzip myGunzip = new GUnzip();
		myGunzip.setProject(myProject);
		myGunzip.init();

		//define the unpacked file path
		String destination_name = target.getName().substring(0, target.getName().length()-3);
		File dest = new File(dest_dir,  destination_name);

		//Do the gunziping
		myGunzip.setSrc(target);
		myGunzip.setDest(dest);
		myGunzip.execute();

		return dest;
	}
	public static File gunzip(File target) throws Exception{
 		//this set up is required by the API
		Project myProject = new Project();
		GUnzip myGunzip = new GUnzip();
		myGunzip.setProject(myProject);
		myGunzip.init();

		//define the unpacked file path
		String destination_name = target.getName().substring(0, target.getName().length()-3);
		File dest = new File(target.getParent(),  destination_name);

		//Do the gunziping
		myGunzip.setSrc(target);
		myGunzip.setDest(dest);
		myGunzip.execute();

		return dest;
	}

	public static File bunzip2(File target, String dest_dir) throws Exception{
		//this set up is required by the API
		Project myProject = new Project();
		BUnzip2 bunzip = new BUnzip2();
		bunzip.setProject(myProject);
		bunzip.init();

		File dest = new File(dest_dir);

		//Do the bziping
		bunzip.setSrc(target);
		bunzip.setDest(dest);
		bunzip.execute();

		return dest;
	}
	
	public static File bunzip2(File target) throws Exception{
		//this set up is required by the API
		Project myProject = new Project();
		BUnzip2 bunzip = new BUnzip2();
		bunzip.setProject(myProject);
		bunzip.init();

		//define the unpacked file path
		String destination_name = target.getName().substring(0, target.getName().length()-3);
		File dest = new File(target.getParent(),  destination_name);

		//Do the bziping
		bunzip.setSrc(target);
		bunzip.setDest(dest);
		bunzip.execute();

		return dest;
	}
	
	public static File unTar(File target) throws Exception{
		//this set up is required by the API
		Project myProject = new Project();
		Untar untar = new Untar();
		untar.setProject(myProject);
		untar.init();

		//define the unpacked file path
		String destination_name = target.getParent();
		File dest = new File(  destination_name );

		//Do the taring
		untar.setSrc(target);
		untar.setDest(dest);
		untar.execute();

		target.delete();
		
		return dest;		
	}
	
	public static File unZip(File target, String destination_path) throws Exception {
		int BUFFER = 4096;
		BufferedOutputStream destination = null;
		BufferedInputStream is = null;
		ZipEntry entry;
		ZipFile zipfile = null;
		zipfile = new ZipFile(target);

		File dest = new File(  destination_path );

		Enumeration<? extends ZipEntry> e = zipfile.entries();
		while(e.hasMoreElements()) {
			entry = (ZipEntry) e.nextElement();
			is = new BufferedInputStream(zipfile.getInputStream(entry));

			int count;
			byte data[] = new byte[BUFFER];
			FileOutputStream fos;
			if(entry.getName().contains("/")){
				String dirname =  entry.getName().substring(0, entry.getName().lastIndexOf('/'));
				File dir = new File(dest, dirname);
				if(! dir.exists()){
					dir.mkdirs(); 
				}
			}

			fos = new FileOutputStream(destination_path + "/" + entry.getName());

			destination = new BufferedOutputStream(fos, BUFFER);

			while ((count = is.read(data, 0, BUFFER)) != -1) {
				destination.write(data, 0, count);
			}
			destination.flush();
			destination.close();
			is.close();

		}
		zipfile.close();

		return dest;
	}
}
