/*
 *  Copyright 2008 The MITRE Corporation (http://www.mitre.org/). All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.mitre.neuro;

import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;

import org.mitre.neuro.containers.Session;
import org.mitre.neuro.containers.Study;
import org.mitre.neuro.containers.Session.Image;

public class ImageLoading {

    protected String upload_path;
    protected Connection connection;

    public ImageLoading(String upload_path, Connection connection){
        this.upload_path = upload_path;
        this.connection = connection;
    }

    public void write_metafile(int study_id, Session scan, Session.Image file) throws Exception {
        String meta_file = upload_path + "/." + file.filename + ".meta";
        PrintWriter writer = new PrintWriter(
                new FileOutputStream(new File(meta_file)));
        try {
            writer.println("path="   + file.path);// + file.getFilename());
            writer.println("study_id=" + study_id);
            writer.println("subject_oid=" +  scan.getSubject().getObject_id());
            writer.println("date=" + scan.getDate_taken());
            writer.println("scan_id=" + scan.getSession_id());
            writer.println("volume_id=" + file.volume_id);
            writer.println("scanner=" + scan.getScanner());
            writer.println("software_version=" + scan.getSoftware_version());

        } finally {
            writer.flush();
            writer.close();
        }
        file.metaFile=meta_file;
    }
    public boolean alreadyQueued(String path) throws Exception{
        String select_sql = "SELECT ID FROM PROCESSING_Q WHERE PROCESSED=-1 AND FILE_PATH=?";
        PreparedStatement statement = this.connection.prepareStatement(select_sql);
        try {
            statement.setString(1, path);
            ResultSet set = statement.executeQuery();
            if (set.next()) {
                return true;
            }
        } finally {
            statement.close();
        }
        return false;
    }
    public void enqueue_metafile(Session.Image file) throws Exception {
        if (alreadyQueued(file.metaFile)){
          //  System.out.println("Already queueued: " + file.getMetaFile());
            return;
        }
        String insert_sql = "INSERT INTO PROCESSING_Q (FILE_PATH) VALUES (?)";
        PreparedStatement statement = this.connection.prepareStatement(insert_sql);
        try {
            statement.setString(1, file.metaFile);
            statement.execute();
        } finally {
            statement.close();
        }

    }

    public void queue_scans(Study study) throws Exception{
        for(Session scan : study.getSessions()){
            for(Image image : scan.getImages()){
                if( ! image.missing){
                    write_metafile(study.getStudy_id(), scan, image);
                    enqueue_metafile(image);
    //                System.out.println("Session " + image.getFilename() + " enqueued" );
                }
            }
        }
    }

    /* public boolean scan_already_loaded(int project_id, String scan_id) throws Exception{
        String select_sql = "SELECT SCAN_ID FROM SCAN_EVENT WHERE PROJECT_ID=? AND SCAN_ID=?";

        PreparedStatement statement = this.connection.prepareStatement(select_sql);
        try {
            statement.setInt(1, project_id );
            statement.setInt(2, scan_id );
            ResultSet set = statement.executeQuery();
            if (set.next()) {
                return true;
            }
        } finally {
            statement.close();
        }
        return false;
    } */
    public static  File find_scan(String root, String image_file){
        File root_file = new File(root);
        if ( ! root_file.exists()) {
            return null;
        }

        File suspect = new File(root_file, image_file);
        if ( suspect.exists() ) {
            return suspect;
        }

/*         String [] list = root_file.list();
        for (String sub : list){
            File file = find_scan(root, sub);
            if (file != null){
                return file;
            }
        } */

        return null;
    }
    /**
     * marks image files as missing/not, returns true if
     * all the image files are found
     * @param study
     * @return
     * @throws Exception
     */
    public boolean check_scans(Study study) throws Exception{
        boolean valid = true;
        for(Session scan : study.getSessions()){
            for(Image image : scan.getImages()){

                File scan_file = find_scan(this.upload_path, image.filename);


                //If we didn't find the file, maybe it was already loaded
                if( scan_file == null){
                    /*
                        if (this.scan_already_loaded(
                            study.getStudy_id(), scan.getSession_id())){
                        image.missing=false;
                        continue;
                    }
                     */
                    valid = false;
                    image.missing=true;
                    continue;
                }

                //The scan file has been located. save this fact in the image object
                image.path=scan_file.getPath();
                image.filename=scan_file.getName();
            }
        }

        return valid;
    }

}
