package org.mitre.neuro;

import java.io.File;
import java.io.FileInputStream;
import java.sql.Connection;
import java.util.Properties;

import org.mitre.neuro.containers.Session;
import org.mitre.neuro.database.StoreSession;

public class UploadComplete {

	public static String getStringProp(Properties props, String key) {
		String property = (String) props.get(key);
		return property;
	}

	public static double getDoubleProp(Properties props, String key) {
		String property = (String) props.get(key);
		if (property == null) {
			return -1;
		}
		try {
			return Double.parseDouble(property);
		} catch (Exception e) {
			return -1;
		}
	}

	public static int getIntProp(Properties props, String key) {
		String property = (String) props.get(key);
		if (property == null) {
			return -1;
		}
		try {
			return Integer.parseInt(property);
		} catch (Exception e) {
			return -1;
		}
	}

	public static void saveStaticInfo(Connection connection, Properties props) {
        // System.out.println( String.valueOf(props) );
		String destination = getStringProp(props,"destination");
		String scan_date = getStringProp(props,"scan_date");

		File dest = new File(destination);


		String scan_id=getStringProp(props,"scan_id");  //this gets overwritten in the database
		int study_id=getIntProp(props,"study_id");
        // System.out.println( getStringProp(props, "subject_oid") );
		int subject_oid=getIntProp(props,"subject_oid");

		String modality=getStringProp(props,"modality");
		String state=getStringProp(props,"state");
		String file_format=getStringProp(props,"file_format");
		String numerical_format=getStringProp(props,"numerical_format");
		int volume_id=getIntProp(props,"volume_id");

		String algorithm_name=getStringProp(props,"algorithm_name");
		String algorithm_version=getStringProp(props,"algorithm_version");
		String algorithm_description=getStringProp(props,"algorithm_description");

		int xfov= getIntProp(props, "xfov");
		int xdimension= getIntProp(props, "xdimension");
		String xorientation=getStringProp(props,"xorientation");
		int xresolution= getIntProp(props, "xresolution");

		int yfov= getIntProp(props, "yfov");
		int ydimension= getIntProp(props, "ydimension");
		String yorientation=getStringProp(props,"yorientation");
		int yresolution= getIntProp(props, "yresolution");

		int zfov= getIntProp(props, "zfov");
		int zdimension= getIntProp(props, "zdimension");
		String zorientation=getStringProp(props,"zorientation");
		int zresolution= getIntProp(props, "zresolution");

		String preview_axial = (String) props.get("preview_axial");
		String preview_coronal = (String) props.get("preview_coronal");
		String preview_sagittal = (String) props.get("preview_sagittal");

		Session scan = new Session();
		Session.Image image = scan.addImage();
        scan.setDate_taken(scan_date);
        image.path=destination;

		 // image.scan_id=scan_id;  //this get set when teh scan_event tuple gets inserted
		 image.study_id=study_id;
		 image.subject_oid=subject_oid;
         image.volume_id = volume_id;

		 image.modality=modality;
		 image.numerical_format=numerical_format;

	     image.algorithm_name=algorithm_name;
		 image.algorithm_version=algorithm_version;
		 image.algorithm_description=algorithm_description;

		 image.xfov=xfov;
		 image.xdimension=xdimension;
		 image.xorientation=xorientation;
		 image.xresolution=xresolution;
		 image.yfov=yfov;
		 image.ydimension=ydimension;
		 image.yorientation=yorientation;
		 image.yresolution=yresolution;
		 image.zfov=zfov;
		 image.zdimension=zdimension;
		 image.zorientation=zorientation;
		 image.zresolution=zresolution;

		 image.preview_axial = preview_axial;
		 image.preview_coronal = preview_coronal;
		 image.preview_sagittal = preview_sagittal;

		 StoreSession store = new StoreSession(connection);
         store.store_session_event(scan, image);  //side effect - this sets the scan_id for the image
		 store.store_image(image);
		 store.store_scanfile(image);

	}

	public static void saveEAVinfo(Connection connecton, Properties props) {
		//TODO: iterate through remaining keys in properties and save as image_value
	}

	public static void saveProcessInfo(Connection connection, Properties props) {
		String original = (String) props.get("file");
		System.out.println(original
				+ " successfully processed! Saving metadata...");

		saveStaticInfo(connection, props);
		saveEAVinfo(connection, props);

	}

	public static void main(String[] args) {
		if (args.length != 1) {
			System.err.println("Please specify a directory to probe");
		}
		File output_file = new File(args[0]);
		if (!output_file.exists()) {
			System.err.println(output_file.getName() + " does not exist");
			System.exit(-1);
		}
		Connection connection = Upload.connect();
		if (connection == null) {
			System.err.println("Failed to connect to database...");
			System.exit(-1);
		}

		try {
			Properties props = new Properties();
			props.load(new FileInputStream(output_file));
            // System.out.println( "In try block.  Props is of size " + props.size() );

			for (Object key_obj : props.keySet()) {
				String key = (String) key_obj;
				String value = (String) props.get(key_obj);
                // System.out.println( key + "|" + value );
				if (key.equalsIgnoreCase("status")) {
					if (value.equalsIgnoreCase("OK")) {
						UploadComplete.saveProcessInfo(connection, props);
						System.exit(0);
					}
				}
				// System.out.println(key + ":" + value);

			}
		} catch (Exception e) {
			e.printStackTrace();
		}
		System.out.println("Upload completion failure");
		System.exit(-1);
	}

}
