/*
 *  Copyright 2008 The MITRE Corporation (http://www.mitre.org/). All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.mitre.neuro.containers;

import java.util.ArrayList;
import java.util.List;
/**
 * This object contains a scan event, and its associated scans
 *
 * @author esax
 *
 */
public class Session {

    Subject subject;

    List<Image> images;

    public class Image {
           public boolean missing = true;
           public String path = null;
           public String filename = null;
           public String metaFile = null;
           public String protocol_name = null;
           public String modality = null;
           public double t1 = Double.MIN_VALUE;
           public double t2 = Double.MIN_VALUE;
           public double te = Double.MIN_VALUE;
           public String num_format = null;
           public double excitations = Double.MIN_VALUE;
           public double flip_angle = Double.MIN_VALUE;
           public double ti = Double.MIN_VALUE;
           public double tr = Double.MIN_VALUE;

           public int volume_id = Integer.MIN_VALUE;
           public String session_id = null;
           public int study_id = Integer.MIN_VALUE;
           public int subject_oid = Integer.MIN_VALUE;

           public String numerical_format = null;

           public String algorithm_name = null;
           public String algorithm_version = null;
           public String algorithm_description = null;

           public double xfov = Double.MIN_VALUE;
           public double xdimension = Double.MIN_VALUE;
           public String xorientation = null;
           public double xresolution = Double.MIN_VALUE;
           public double yfov = Double.MIN_VALUE;
           public double ydimension = Double.MIN_VALUE;
           public String yorientation = null;
           public double yresolution = Double.MIN_VALUE;
           public double zfov = Double.MIN_VALUE;
           public double zdimension = Double.MIN_VALUE;
           public String zorientation = null;
           public double zresolution = Double.MIN_VALUE;

           public String preview_axial = null;
           public String preview_coronal = null;
           public String preview_sagittal = null;
    }
    /**
     * Set of images from a scan
     */
    String session_id = null;
    String scanner = null;
    String date_taken = null;
    String software_version = null;
    String location = null;

    public String getLocation() {
        return this.location;
    }
    public void setLocation(String location) {
        this.location = location;
    }
    public Session(){
        this.subject = new Subject();
        this.images = new ArrayList<Image>();
    }
    public Image addImage(){
        Image vol = new Image();
        this.images.add(vol);
        return vol;
    }
    public Session(Subject subject){
        this();
        this.subject = subject;
    }
    public String getSoftware_version() {
        return this.software_version;
    }
    public void setSoftware_version(String software_version) {
        this.software_version = software_version;
    }
    public Subject getSubject() {
        return subject;
    }
    public void setSubject(Subject subject) {
        this.subject = subject;
    }
    public List<Image> getImages() {
        return images;
    }
    public void setImages(List<Image> images) {
        this.images = images;
    }
    public String getSession_id() {
        return session_id;
    }
    public void setSession_id(String session_id) {
        this.session_id = session_id;
    }
    public String getScanner() {
        return scanner;
    }
    public void setScanner(String scanner) {
        this.scanner = scanner;
    }
    public String getDate_taken() {
        return date_taken;
    }
    public void setDate_taken(String date_taken) {
        this.date_taken = date_taken;
    }

    public boolean equals(Object other) {
       // Not strictly necessary, but often a good optimization
       if (this == other)
         return true;
       if (!(other instanceof Session))
         return false;
       Session otherA = (Session) other;
       // System.out.println( "---got here---" );
       return
         (this.hashCode() == other.hashCode());
    }

    public int hashCode() {
        int hash = (subject.getSubject_id() == null ? 0 : subject.getSubject_id().hashCode()) +
            (date_taken == null ? 0 : date_taken.hashCode()) +
            (session_id == null ? 0 : session_id.hashCode()) ;
            // System.out.println( subject.getSubject_id() + date_taken + session_id + hash );
        return hash;
    }

    /**
     * put here to test the .equals method
     */
    public static void main(String args[])
    {
        Session a = new Session();
        Session b = new Session();
        a.setSubject(new Subject("test"));
        a.setSession_id( "1" );
        a.setDate_taken( "Yarrr R'lyeh!!" );
        b.setSubject(new Subject("test"));
        b.setSession_id( "1" );
        b.setDate_taken( null );

        System.out.println( "Are the equal?  " + a.equals(b) );
    }

}
