/*
 *  Copyright 2008 The MITRE Corporation (http://www.mitre.org/). All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.mitre.neuro.containers;

import java.util.ArrayList;
import java.util.List;

public class Study {
	int study_id;
	String investigator;
	String pi_email;
	String funding_info;
	String grant_name;
	List<Session> sessions;

	public Study(){
		this.sessions = new ArrayList<Session>();
	}
	public void addSession(Session scan){
		this.sessions.add(scan);
	}
	public String getInvestigator() {
		return investigator;
	}
	public void setInvestigator(String investigator) {
		this.investigator = investigator;
	}
	public String getPi_email() {
		return pi_email;
	}
	public void setPi_email(String pi_email) {
		this.pi_email = pi_email;
	}
	public String getFunding_info() {
		return funding_info;
	}
	public void setFunding_info(String funding_info) {
		this.funding_info = funding_info;
	}
	public String getGrant_name() {
		return grant_name;
	}
	public void setGrant_name(String grant_name) {
		this.grant_name = grant_name;
	}
	public List<Session> getSessions() {
		return sessions;
	}
	public void setSessions(List<Session> sessions) {
		this.sessions = sessions;
	}
	public String toString(){
        return "PI   : " + this.getInvestigator() + "\n" +
		"email: " + this.getPi_email() + "\n" +
		"funding: " + this.getFunding_info()+ "\n" +
		"grant: " + this.getGrant_name()+ "\n" +
        "sessions: " + this.getSessions().size()+ "\n";
	}
	public int getStudy_id() {
		return study_id;
	}
	public void setStudy_id(int study_id) {
		this.study_id = study_id;
	}
}
