/*
 *  Copyright 2008 The MITRE Corporation (http://www.mitre.org/). All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.mitre.neuro.database;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;

import org.mitre.neuro.containers.Session;
import org.mitre.neuro.containers.Study;

public class StoreStudy {

	Connection connection;

	public StoreStudy(Connection connection){
		this.connection = connection;
	}

	public static boolean get_study(Connection connection, Study study) throws Exception {
		String sql = "SELECT PROJECT_ID, PI_NAME, PI_EMAIL, funding_info from PROJECT " +
				"where GRANT_NAME=?";
        // System.out.println( sql );
        // System.out.println( study.getGrant_name() );
        //System.out.println( study.getInstitution() );
		PreparedStatement statement = connection.prepareStatement(sql);
		try {
			statement.setString(1, study.getGrant_name());
			//statement.setString(2, study.getInstitution());
			statement.execute();
			ResultSet result = statement.getResultSet();
			if(result.next()){
				study.setStudy_id( result.getInt(1) );
                //	System.out.println("Study found: " + study.getGrant_name());
                study.setPi_email( result.getString("PI_EMAIL") );
                study.setInvestigator( result.getString("PI_NAME") );
                study.setFunding_info( result.getString("funding_info") );
				return true;
			}
		} finally {
			statement.close();
		}
		return false;
	}

	public void insert_study(Study study) throws Exception {
		String sql = "INSERT INTO PROJECT (grant_name, pi_name, pi_email, funding_info) " +
				"VALUES (?, ?, ?, ?);";
		PreparedStatement statement = this.connection.prepareStatement(sql);

		try {

			statement.setString(1, study.getGrant_name());
			statement.setString(2, study.getInvestigator());
			statement.setString(3, study.getPi_email());
			statement.setString(4, study.getFunding_info());
			statement.execute();

		} finally {
			statement.close();
		}

		sql = "SELECT currval(pg_get_serial_sequence('project', 'project_id'));";
		statement = this.connection.prepareStatement(sql);
		try{
			ResultSet generated_keys = statement.executeQuery();
			if(generated_keys.next()){
				study.setStudy_id(generated_keys.getInt(1));
				System.out.println("Study " + study.getStudy_id() +" added...");
			}

		} finally {
			statement.close();
		}
	}

	public void store(Study study) throws Exception {
		if( ! get_study(connection, study)){
			System.out.println("Storing Study...");
			insert_study(study);
		}

		StoreSession scans = new StoreSession(study, this.connection);
		for ( Session scan : study.getSessions()){
           // System.out.println( "\tstoring scan_event " + scan.getSession_id() );
			scans.store_scan(scan);
		}

	}
}
