/*
 *  Copyright 2008 The MITRE Corporation (http://www.mitre.org/). All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.mitre.neuro.database;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;

import org.mitre.neuro.containers.Interview;
import org.mitre.neuro.containers.Study;
import org.mitre.neuro.containers.Subject;

public class StoreSubject {

	Connection connection;
	//what type of cache to use?
	//HashMap<>
	//or single element?

	public StoreSubject(Connection connection){
		this.connection = connection;

	}

	public boolean get_subject_id(Subject subject, int study_id) throws Exception {
		String sql = "SELECT SUBJECT_OID from SUBJECT " +
				"where PROJECT_ID=? and SUBJECT_ID=?;";
		//System.out.println("SubjectID: " + subject.getSubject_id());
		PreparedStatement statement = this.connection.prepareStatement(sql);
		try {
			statement.setInt(1, study_id);
			statement.setString(2, subject.getSubject_id());
			if(statement.execute()){
				ResultSet result = statement.getResultSet();
				if(result.next()){
					subject.setObject_id( result.getInt(1) );
                    // System.out.println( "SubjectOID set to " + subject.getObject_id() );
					return true;
				}
			}
		} finally {
			statement.close();
		}
		return false;
	}

	public void insert_subject(Subject subject, int study_id) throws Exception {

		String sql = "INSERT INTO SUBJECT ( " +
				"subject_id ," +				//1
				"project_id ,  " +				//2
				"initial_exam, " +				//3
				"birthdate, " +					//4
				"nation_of_residence, " +		//5
				"gender, " +					//6
				"race, " +						//7
				"primary_language, " +			//8
				"second_language, " +			//9
				"marital_status, " +			//12
				"education, " +					//13
				"handedness, " +				//14
				"height, " +					//15
				"weight" +					//16
		")" +
		"VALUES (" +
		"?,?,?,?,?," +
		"?,?,?,?,?," +
		"?,?,?,?);";

		//System.out.println("INSERT|STUDY: " + sql);

		PreparedStatement statement = this.connection.prepareStatement(sql);

		try {
			statement.setString(1, subject.getSubject_id());
			statement.setInt(2, study_id);
			if(subject.getInitial_exam() == null){
				statement.setNull(3, java.sql.Types.DATE);
			}
			else{
				statement.setDate(3, new java.sql.Date(subject.getInitial_exam().getTime()));
			}
			if(subject.getBirth() == null){
				statement.setNull(4, java.sql.Types.DATE);
			}
			else{
				statement.setDate(4, new java.sql.Date(subject.getBirth().getTime()));
			}
			statement.setString(5, subject.getNationality());
			statement.setString(6, subject.getGender());
			statement.setString(7, subject.getRace());
			statement.setString(8, subject.getPrimary_language());
			statement.setString(9, subject.getSecondary_language());
			statement.setString(10, subject.getMarital_status());
           if( subject.getEducation() == Integer.MIN_VALUE )
                statement.setNull(11, java.sql.Types.INTEGER );
            else
			    statement.setInt(11, subject.getEducation());

			statement.setString(12, subject.getHandedness());

            if( subject.getHeight() == Integer.MIN_VALUE )
                statement.setNull(13, java.sql.Types.INTEGER );
            else
                statement.setInt(13, subject.getHeight());

            if( subject.getWeight() == Integer.MIN_VALUE )
                statement.setNull(14, java.sql.Types.INTEGER );
            else
			    statement.setInt(14, subject.getWeight());

			statement.execute();

		} finally {
			statement.close();
		}

		sql = "SELECT currval(pg_get_serial_sequence('subject', 'subject_oid'));";
		statement = this.connection.prepareStatement(sql);
		try{
			ResultSet generated_keys = statement.executeQuery();
			if(generated_keys.next()){
				subject.setObject_id(generated_keys.getInt(1));
				// System.out.println("subject " + subject.getObject_id() + " added...");
			}

		} finally {
			statement.close();
		}
	}

	public void store_subject(Subject subject, Study study) throws Exception {
		//System.out.println("Storing subject...");
		if (! this.get_subject_id(subject, study.getStudy_id())){
			this.insert_subject(subject, study.getStudy_id());
		}
        ///side effect - either one of the calls above sets the object_id (subject_oid in the database)
        // System.out.println( subject.getSubject_id() +"|"+ subject.getObject_id());

		StoreInterview store = new StoreInterview(this.connection, subject);
		for(Interview interview : subject.getInterviews()){
			store.store_interview(interview);
		}

	}
}
