/*
 *  Copyright 2008 The MITRE Corporation (http://www.mitre.org/). All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.mitre.neuro.demo;

import java.io.File;
import java.io.FileInputStream;

import org.mitre.neuro.SpreadSheetReader;
import org.mitre.neuro.SpreadSheetReader.InputType;

public class DemoSpreadSheetReader {

	public static void main(String [] args){
		 try {
			 FileInputStream fis = new FileInputStream(new File("demo.xls"));
			 SpreadSheetReader reader = new SpreadSheetReader(InputType.BIFF);
			 reader.read(fis, ".");
			 fis.close();
			} catch (Exception e) {
				e.printStackTrace();
			}
			System.out.println("done.");
	}
}
