/*
 *  Copyright 2008 The MITRE Corporation (http://www.mitre.org/). All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.mitre.neuro.excel;

import java.util.Date;

public class Datum {
	public enum Type { EMPTY, STRING, NUMBER, FORMULA, DATE };

    public final static String EMPTY_STR = "";
	protected String string_dat;
	protected double number_dat;
	protected String formula;
	protected String date;
	protected Type t;

	protected boolean locked;

	public static Datum empty() {
		Datum d = new Datum();
		d.t = Type.EMPTY;
		return d;
	}
	public static Datum string(String label) {
		Datum d = new Datum();
		d.string_dat = label;
		d.t = Type.STRING;
		return d;
	}
	public static Datum formula(String formula) {
		Datum d = new Datum();
		d.formula = formula;
		d.t = Type.FORMULA;
		return d;
	}
	public static Datum number(double number_dat) {
		Datum d = new Datum();
		d.number_dat = number_dat;
		d.t = Type.NUMBER;
		return d;
	}
	public static Datum date(Date date) {
		Datum d = new Datum();
		d.date = date.toString();
		d.t = Type.DATE;
		return d;
	}

	/**
	 * "locks" the field in the resulting spreadsheet
	 * This indicates that the cell should not be
	 * edited.
	 */
	public Datum lock(){
		this.locked = true;
		return this;
	}

	public String getDate() {
		return date;
	}
	public String getFormula() {
		return formula;
	}
	public double getNumber_dat() {
		return number_dat;
	}
	public String getString_dat() {
        if (string_dat == null)
        {
            return EMPTY_STR;
        }
        else
            return string_dat;
	}
	public Type getT() {
		return t;
	}

	public boolean isLocked(){
		return this.locked;
	}

}
