/*
 *  Copyright 2008 The MITRE Corporation (http://www.mitre.org/). All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.mitre.neuro.excel.biff;

import java.io.InputStream;
import java.util.HashMap;

import jxl.Cell;
import jxl.Sheet;
import jxl.Workbook;
import jxl.WorkbookSettings;

import org.mitre.neuro.excel.Datum;
import org.mitre.neuro.excel.ExcelReader;
import org.mitre.neuro.excel.Row;
import org.mitre.neuro.excel.Worksheet;

/**
 * Uses the JXL library to read an excel document into memory
 */
public class BIFFReader extends ExcelReader {

	public BIFFReader() {
		super();
	}

	public HashMap<String, Worksheet> readSheets(InputStream input) throws Exception {
		HashMap<String, Worksheet> sheets = new HashMap<String, Worksheet>();
		Workbook book = null;
		try{
			WorkbookSettings settings = new WorkbookSettings();
			settings.setSuppressWarnings(true);
			book = Workbook.getWorkbook(input, settings);
			for(int i =0; i < book.getNumberOfSheets(); i++){
				Sheet sheet = book.getSheet(i);
				Worksheet worksheet = new Worksheet(sheet.getName(), i);
				for(int j=0; j < sheet.getRows(); j++){
					worksheet.addRow(this.readRow(sheet, j));
				}
				sheets.put(worksheet.getName(), worksheet);
			}
		} finally { //necessary to free up memory
			if( book != null ){
				book.close();
			}
		}
		return sheets;

	}

	protected Row readRow(Sheet sheet, int row_index){
		Row row = new Row(row_index); //your boat...
		Cell [] cells = sheet.getRow(row_index);
		for(Cell cell : cells){
			row.addColumn(cell.getColumn(), this.readCell(cell));
		}
		return row;
	}

	protected Datum readCell(Cell cell) {
		Datum cell_data = null;
		if("".equals(cell.getContents())){
			return Datum.empty();
		}
		cell_data = Datum.string(cell.getContents());

        //System.out.println("cell: " + cell.getContents());
    /*    if(cell.getType() == CellType.LABEL){
				if("".equals(cell.getContents())){
				return Datum.empty();
			}
			cell_data = Datum.string(cell.getContents());
        }
		else if(cell.getType() == CellType.NUMBER){
			cell_data = Datum.number(((NumberCell)cell).getValue());
		}
		else if(cell.getType() == CellType.DATE){
			cell_data = Datum.date(((DateCell)cell).getDate());
		}
		else if(cell.getType() == CellType.STRING_FORMULA){
			try {
				cell_data = Datum.formula(((StringFormulaCell)cell).getFormula());
			} catch (FormulaException e) {
				System.err.println("Error reading cell formula: " +  e.getMessage());
			}
		}
		else{
			cell_data = Datum.empty();
		}*/
		return cell_data;
	}

}
