CREATE SEQUENCE PROCESS_MARKER;

CREATE TABLE PROCESSING_Q (
    ID SERIAL PRIMARY KEY,
    FILE_PATH text,
    PROCESSED integer default -1
);

CREATE TABLE algorithm (
    algorithm_id serial primary key,
    name text,
    version text,
    description text
);
CREATE TABLE attribute (
    attribute_id integer NOT NULL  primary key,
    entity_id integer,
    name text,
    units text,
    description text
);
CREATE TABLE country (
    countrycd text NOT NULL,
    name text NOT NULL
);
CREATE TABLE derivation_history (
    volume_id int NOT NULL,
    source_volume_id int NOT NULL
);

CREATE TABLE entity (
    entity_id integer NOT NULL  primary key,
    name text,
    description text
);
CREATE TABLE image_metrics (
    filename text NOT NULL,
    metric_id text NOT NULL,
    value text
);
CREATE TABLE images (
    volume_id int NOT NULL,
    filename text NOT NULL primary key
);
CREATE TABLE label_sql (
    table_name text,
    sql_clause text
);
CREATE TABLE latticegroup (
    latticegroupid character varying(50) NOT NULL primary key,
    latticegroupname character varying(50),
    latticegroupdesc character varying(200),
    CONSTRAINT latticegroup_latticegroupid_check CHECK ((latticegroupid IS NOT NULL))
);
CREATE TABLE message (
    id integer NOT NULL,
    time_sent text,
    sender character varying(50),
    recipient character varying(50),
    title text,
    body text,
    status character varying(15)
);
CREATE TABLE metrics (
    metric_id text NOT NULL primary key,
    metric_name text NOT NULL,
    description text
);

CREATE TABLE parameters (
    volume_id int NOT NULL,
    parameter text NOT NULL,
    value text NOT NULL
);
CREATE TABLE people (
    email character varying(100) not null primary key,
    peopletypeid integer,
    "password" character varying(50),
    latticegroupid text,
    firstname text,
    lastname text,
    company text,
    department text,
    address text,
    city text,
    state text,
    zip text,
    country text,
    pi character varying(1),
    comments text,
    validationcode character varying(12),
    validated character varying(1)

);
CREATE TABLE project (
    project_id serial NOT NULL primary key,
    grant_name text NOT NULL UNIQUE,
    research_title text,
    research_desc text,
    funding_info text,
    start_date text,
    end_date text,
    current_budget text,
    related_people text,
    pi_name text,
    pi_email text NOT NULL
);

create table project_security (
 grant_name         text REFERENCES project(grant_name),
 security_setting   text ,
 label              text
);


CREATE TABLE quality (
    volume_id int NOT NULL,
    quality_attribute1 double precision,
    quality_attribute2 double precision
);
CREATE TABLE scan_event (
    scan_id serial NOT NULL primary key,
    subject_oid integer,
    project_id integer,
    scanner_id text,
    location text,
    scan_date date,
    software_version text
);

CREATE VIEW source_files AS
    SELECT derivation_history.volume_id, images.filename FROM (images JOIN derivation_history ON ((images.volume_id = derivation_history.source_volume_id)));
CREATE TABLE subject (
    subject_oid serial NOT NULL  primary key,
    subject_id text,
    project_id integer,
    initial_exam date,
    birthdate date,
    nation_of_residence text,
    gender text,
    race text,
    primary_language text,
    second_language text,
    marital_status text,
    education numeric,
    handedness text,
    height numeric,
    weight numeric
);
CREATE TABLE subject_label (
    subject_oid integer NOT NULL,
    "owner" text,
    label text NOT NULL
);
CREATE TABLE subject_values (
    date date NOT NULL,
    value text,
    attribute_id integer NOT NULL,
    subject_oid integer NOT NULL
);

CREATE TABLE volume (
    volume_id serial primary key,
    modality text,
    protocol_name text,
    t1 double precision,
    t2 double precision,
    tr double precision,
    ti double precision,
    te double precision,
    numerical_format text,
    flip_angle double precision,
    excitations integer,
    algorithm_id int,
    xfov double precision,
    xdimension integer,
    xorientation text,
    xresolution double precision,
    yfov double precision,
    ydimension integer,
    yorientation text,
    yresolution double precision,
    zfov double precision,
    zdimension integer,
    zorientation text,
    zresolution double precision,
    scan_id integer
);

--
-- Name: images_label; Type: VIEW; Schema: public; Owner: jchoyt
--

CREATE VIEW images_label AS
    SELECT images.filename, project.pi_email AS owner, s.label FROM (((((project_security s JOIN project USING (grant_name)) JOIN subject USING (project_id)) JOIN scan_event USING (subject_oid)) JOIN volume USING (scan_id)) JOIN images USING (volume_id));


--
-- Name: subject_values_label; Type: VIEW; Schema: public; Owner: jchoyt
--

CREATE VIEW subject_values_label AS
    SELECT subject.subject_oid, s.label FROM (((project_security s JOIN project USING (grant_name)) JOIN subject USING (project_id)) JOIN subject_values USING (subject_oid));

