/*
 *  Copyright 2008 The MITRE Corporation (http://www.mitre.org/). All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

import java.util.*;
import java.io.*;
import java.sql.*;


/**
 *  This file grabs all information regarding a symlink.  It is necessary to use the file name relative
 *  to the images directory where neuroweb knows to look for the images.  This can be found by examining
 *  the standard.properties file from your neuroweb installation. Look for a property named "imagesDir"
 *  which should have a value like "[PATH]/neuroImages/". The value of [PATH] can be determined from the
 *  "BasePath" property in the config.properties file.  Both files can be found in the WEB-INF/props directory
 *  of your neuroweb installation.
 *
 *  An example of a successful program run is below.
 */
public class GetSymlinkInfo
{
    private String query = "select * from images natural join volume where filename=?";
    private Properties info = new Properties();

    public static void main (String[] args)
    throws Exception
    {
        GetSymlinkInfo doer = new GetSymlinkInfo();
        if( args.length != 2 )
        {
            System.out.println( "usage: java GetSymlinkInfo <db config file> <symlink filename>" );
            System.exit(10);
        }
        doer.getInfo(args[0], args[1]);
    }

    public void getInfo(String config, String filename)
    throws Exception
    {
        /* //get absolute filename
        File file = new File(filename);
        filename = file.getAbsolutePath(); */
        info.load(new FileReader(config));
        Class.forName( info.getProperty("driver"));
        Connection conn = DriverManager.getConnection(info.getProperty("server"), info);
        //get a reference to the statement
        PreparedStatement s = conn.prepareStatement( query );
        s.setString( 1, filename );
        ResultSet rs = s.executeQuery();
        Properties output = new Properties();
        String volumeId = null;
        ResultSetMetaData md = rs.getMetaData();
        int count = md.getColumnCount();

        if(rs.next())
        {
            for ( int i = 0; i < count; i++ )
            {
                String name = md.getColumnName( i + 1 );
                String value = rs.getString( i + 1 );
                //System.out.println( i + name + value );
                if( name.equalsIgnoreCase("volume_id") )
                {
                    volumeId = value;
                }
                output.setProperty( name, String.valueOf(value));
            }
        }
        else
        {
            output.setProperty( filename, "not found" );
        }
        //FileWriter writer = new FileWriter(volumeId + ".props" );
        String comments = "This is the information for file " + filename;
        output.store( System.out, comments);
    }
}

/*
Example:
[jchoyt@mm141783-pc aux]$ java -classpath .:../tomcat/webapps/neuroWeb/WEB-INF/lib/postgresql-8.1-407.jdbc3.jar GetSymlinkInfo dbconfig.props links/JHU/1000101/1000101_3_1.nii.bz2
#This is the information for file links/JHU/1000101/1000101_3_1.nii.bz2
#Mon Dec 29 16:55:03 EST 2008
zorientation=null
numerical_format=16 bit unsigned
ystart=null
xresolution=0.828125
state=null
zstart=null
zdimension=60
xstep=null
algorithm_id=null
xdimension=256
volume_id=1
endianness=little
zstep=null
xfov=212
scan_id=1
file_format=null
yfov=212
xorientation=null
filename=links/JHU/1000101/1000101_3_1.nii.bz2
yresolution=0.828125
zfov=132
ydimension=256
yorientation=null
modality=DTI
ystep=null
zresolution=2.2
xstart=null

*/
