<%--
Copyright 2008 The MITRE Corporation (http://www.mitre.org/). All Rights Reserved.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
 --%>
<%@ taglib uri="/WEB-INF/mrald.tld" prefix="mrald"%>

<%@ page import = "java.io.File"%>
<%@ page import = "java.util.Enumeration"%>
<%@ page import = "javax.servlet.http.HttpServletRequest"%>
<%@ page import = "org.mitre.lattice.util.ImageUtils"%>
<%@ page import = "org.mitre.mrald.util.*"%>
<mrald:validate />
<%
    // Snoop.logParameters(request);
    User mraldUser = (User)session.getAttribute(Config.getProperty("cookietag"));
    String action = WebUtils.getRequiredParameter(request, "fileAction");
    LatticeFactory latticeFactory = (LatticeFactory)Config.getLatticeFactory();
    ImageUtils imageu = latticeFactory.getImageUtils();
    if (action.equals("upload"))
    {
        imageu.storeImage(  request,  mraldUser );
        response.sendRedirect( "successClose.html" );
    }
    else if (action.equals("download"))
    {
        String fileName = WebUtils.getRequiredParameter(request,"fileName");
        imageu.downLoadFile( response, Config.getProperty("imagesDir") + fileName);

         String clientAddress = request.getRemoteAddr();
         String clientHost = request.getRemoteHost();
         String logFileSeparator = "--------------------\n";
         String logData =  "Client " + clientAddress + " on host " +  clientHost + " is downloading the following file : "+ fileName+ "\n\n" +  logFileSeparator;

         MraldOutFile.logToFile(Config.getProperty("STATLOGFILE"), logData);

        response.sendRedirect( "successClose.html" );
    }
    else
    {
        throw new JspException("Sorry, no appropriate action was given.  Please contact your administrator or the development team at <a href=\"mailto:neuroinformatics-list@lists.mitre.org\">neuroinformatics-list@lists.mitre.org</a>.");
    }
%>
<%--
 * :mode=jsp:tabSize=4:indentSize=4:noTabs=true:
 * :folding=indent:collapseFolds=0:wrap=none:maxLineLen=80:
--%>
