<%--
Copyright 2008 The MITRE Corporation (http://www.mitre.org/). All Rights Reserved.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
 --%>
<%@ taglib uri="/WEB-INF/mrald.tld" prefix="mrald"%>
<%@ taglib uri="/WEB-INF/lattice.tld" prefix="lattice"%>
<%@ page errorPage="../ErrorHandler.jsp" %>
<%@ page import="org.mitre.mrald.util.*" %>
<%
    String badLogin = WebUtils.getOptionalParameter( request, "badLogin" );
    User mraldUser = (User)session.getAttribute(Config.getProperty("cookietag"));
    String userStr= "";
    Cookie[] cookies = request.getCookies();

    for ( int i = 0; cookies!=null && i < cookies.length; i++)
    {
        String name = cookies[i].getName();
        if ( name.equalsIgnoreCase( Config.getProperty("cookietag") ) )
        {
            userStr = cookies[i].getValue();
        }
    }
    if (mraldUser != null)
        userStr = mraldUser.getEmail();
%>
<html>
<script language="JavaScript1.2" type="text/javascript">
        function checkForm(form)
        {
            var userName = form.userName.value;
            var passWord = form.password.value;
          if( (!userName) )
            {
                alert ("\nYou must enter a valid email address to continue.")
                return false;
            }
        <% if ( Config.usingSecurity ) { %>
          else if( (!passWord) )
          {
            alert ("\nYou must enter a password.")
            return false;
          }
        <% } %>
            else return true;
        }
	</script>
  <head>
  	<%@include file='title.html'%>
</head>
<body>
<div id="wrap">
<%@include file='pageHeader.jsp'%>
<div id="content">
<h2><strong> Log in to neuro<span class="gray">Web</span></strong></h2>

    <form action="FormSubmit" method="post" enctype="x-www-form-urlencoded" onSubmit="return checkForm(this)" name="form">
	  <input type="hidden" name="workflow" value="UserLogin" />
      <input type="hidden" name="loginAction" value="checkUser" />
      <center>
        <div class="floating-text" style="width:600px;" name="floatingbox">
        <% if( badLogin.equals("true") ) {%>
            <div style="background:#ff8f8f;padding:.5em;text-align:center;">Username and password do not match any registered user.</div>
        <%}%>
		<table border="0">
		<tr>
		<td>Email Address:</td>
		<td><input type="text" name="userName" size="30" maxlength="80" value="<%= userStr %>" /></td>
		</tr>
        <%  if ( Config.usingSecurity ) {  %>
		<tr>
        <td>Password:</td>
        <td><input type="password" name="password" size="30" maxlength="80" value="" /></td>
		</tr>
		</table>
        <br />
        Not a registered user?
        <a href="RegistrationForm.jsp">Register here</a> or <a href="RegisterAsGuest.jsp">sign in as a guest</a>
        <br />
        Forgotten your password?
        <a href="RetrievePassword.jsp?pageurl=<%=Config.getProperty( "BaseUrl" )%>"> Request a new one</a>
        <% }
        else
        { %>
		</table>
        <% } %><%-- <br />For more information on our use of cookies, you may review <a href="cookie.jsp">our cookie policy</a>. --%></div>
        <input type="submit" value="Login" />
      </center>
    </form>
       <br/>
       <h2></h2>
    </div>
  </body>
</html>