<%--
Copyright 2008 The MITRE Corporation (http://www.mitre.org/). All Rights Reserved.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
 --%>
<%@ taglib uri="/WEB-INF/mrald.tld" prefix="mrald"%>
<%@ taglib uri="/WEB-INF/lattice.tld" prefix="lattice"%>
<%@ page errorPage="../ErrorHandler.jsp" %>
<%@ page import="org.mitre.mrald.util.*" %>
<html>
    <head>
        <%@include file='title.html'%>
    </head>
    <body>
        <div id="wrap">
            <%@include file='pageHeader.jsp'%>
                <mrald:validate />

            <div id="content">
                <h2><strong> Add a new <span class="gray">Entity</span></strong></h2>
                <br/>
                <h2>What is an entity?</h2>
                An entity is a single test, attribute, or other information you wish to store about a subject.  Another name may be "Interview Item".  An entity will have several "attributes" or individual measures about the entity.<br/>
                <br/>
                Some examples:<br/>
                <br/>
                Example 1: Verbal Recent Memory<br/>
                <ul>
                    <li>Description: 	Twenty words are displayed on the screen at the rate of one every three seconds . The subject then is shown 40 more words randomly distributed between targets and distractors. For each word in the recognition phase the subject must press the yes or no arrow key to indicate whether or not the words was on the first list. All words are of Thorndike-Lorge frequency AA (very common) and are approximately of 6th grade vocabulary level. Parameters derived from signal detection theory are calculated, including adjusted accuracy, response bias, and position effects. There is a delayed recall of the word list 20 minutes later, in which the same choices of targets and distractors are presented, but in a different order. Recorded scores include correct responses, false responses, correct rejections, and misses. See California Verbal Learning Test.</li>
                    <li>Attributes:</li>
                    <ul>
                        <li>Hits - number of correct yes responses</li>
                        <li>Misses - number of incorrect no responses</li>
                        <li>Reject - number of correct no responses</li>
                        <li>Alarm - number of incorrect yes responses</li>
                    </ul>
                </ul>
                Example 2: Schizophrenia
                <ul>
                    <li>Description: A mental disorder characterized by disturbances in form and content of thought (loosening of associations, delusions, and hallucinations), mood (blunted, flattened, or inappropriate affect), sense of self and relationship to the external world (loss of ego boundaries, dereistic thinking, and autistic withdrawal), and behavior (bizarre, apparently purposeless and stereotyped activity or inactivity).</li>
                    <li>Attributes:</li>
                    <ul>
                        <li>current - patient currently suffers from the medical condition</li>
                        <li>ever - patient has suffered from the medical condition in the past</li>
                        <li>comments - freeform comments</li>
                    </ul>
                </ul>

                <br/>
                <div class="floating-text" style="text-align:center;border:1px solid #4088b8;padding:1.5em;margin-bottom:2em;" name="floatingbox">
                    <form enctype="x-www-form-urlencoded" action="addEntityProcess.jsp" name="FormInsert" method="POST">
                        Entity Name: <input name="name" size="75"/>
                        <br/><br/>
                        Description:<br/>
                        <textarea rows="20" cols="75" name="description"></textarea>
                        <br/><br/>
                        <input type="submit" value="Add New Entity"/>
                    </form>
                </div>
            </div>
            <%@include file='menus.jsp'%>
        <%-- menu.jsp includes close for wrap <div> --%>
    </body>
</html>

