<%--
Copyright 2008 The MITRE Corporation (http://www.mitre.org/). All Rights Reserved.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
 --%>
<%@ taglib uri="/WEB-INF/mrald.tld" prefix="mrald"%>
<%@ taglib uri="/WEB-INF/lattice.tld" prefix="lattice"%>
<%-- <%@ page errorPage="ErrorHandler.jsp" %> --%>
<%@ page import="org.mitre.mrald.util.*" %>
<%@ page import = "java.util.*" %>
<%@ page import = "java.sql.*" %>
<%
    String entityName = MiscUtils.checkApostrophe(WebUtils.getRequiredParameter(request, "entityname"));
    String entityDescription = MiscUtils.checkApostrophe(WebUtils.getRequiredParameter(request, "description"));
    MraldConnection conn = new MraldConnection("main");
    ResultSet rs =null;

%>
<html>
    <head>
        <%@include file='title.html'%>
    </head>
    <body>
        <div id="wrap">
            <%@include file='pageHeader.jsp'%>
                <mrald:validate />

            <div id="content">
                <h2><strong> Add an new <span class="gray">Entity (con't)</span></strong></h2>
                <br/>
                <h2>Step 3 - Store new attribute</h2>
                <%
                try{
                    //add the entity
                    int entityId = 0;
                    rs=conn.executeQuery("select max(entity_id) from entity");
                    if(rs.next())
                    {
                        //the result set should contain the new entity ID.
                        entityId = rs.getInt(1);
                        entityId++;
                    }
                    else
                        throw new SQLException("Need the value for the new entity ID");

                    String query = "insert into entity (entity_id, name, description) values ('" +
                        entityId + "', '" + entityName + "', '" + entityDescription + "')";
                    MraldOutFile.appendToFile( query );
                    int throwaway = conn.executeUpdate( query );
                    out.write("Entity " + entityName + " added successfully.");


                    //get next attribute ID
                    int attrId = 0;
                    rs=conn.executeQuery("select max(attribute_id) from attribute");
                    if(rs.next())
                    {
                        //the result set should contain the new entity ID.
                        attrId = rs.getInt(1);
                        attrId++;
                    }
                    for (Enumeration e = request.getParameterNames() ; e.hasMoreElements() ;)
                    {
                        //this is the new attribute name
                        String key = (String) e.nextElement();
                        //get the attributes associated with the entity
                        if( key.startsWith("aname" ) )
                        {
                            String attrName = MiscUtils.checkApostrophe(WebUtils.getOptionalParameter(request, key, null ));
                            if( attrName == null || attrName.equals("") )
                            {
                                continue;
                            }
                            String num = key.substring( 5 );
                            String desc = MiscUtils.checkApostrophe(WebUtils.getRequiredParameter(request, "adesc"+num ));
                            if( desc.equals("") )
                            {
                                throw new NullPointerException("You must provide a description of the attribute");
                            }

                            query = "insert into attribute ( attribute_id, entity_id, name, description) values ( " +
                                attrId++ + ", " + entityId + ", '" + attrName + "', '" + desc + "')";
                            MraldOutFile.appendToFile( query );
                            conn.executeUpdate( query );
                            out.write("\n<br/>" + attrName + " added to " + entityName );
                        }
                    }
                }
                catch (Exception e)
                {
                    e.printStackTrace();
                    throw e;
                }
                %>
            </div>
            <%@include file='menus.jsp'%>
        <%-- menu.jsp includes close for wrap <div> --%>
    </body>
</html>

