//Ajax Tooltip script: By JavaScript Kit: http://www.javascriptkit.com

var ajaxtooltip={
	useroffset: [15, 10], //additional x and y offset of tooltip from mouse cursor, respectively

	positiontip:function($tooltip, e){
		var docwidth=(window.innerWidth)? window.innerWidth-15 : ajaxtooltip.iebody.clientWidth-15
		var docheight=(window.innerHeight)? window.innerHeight-18 : ajaxtooltip.iebody.clientHeight-15
		var twidth=$tooltip.width()
		var theight=$tooltip.height()
		var tpositionx=((e.clientX+ajaxtooltip.useroffset[0]+twidth>docwidth)? e.pageX-twidth : e.pageX) + ajaxtooltip.useroffset[0]
		var tpositiony=((e.clientY+ajaxtooltip.useroffset[1]+theight>docheight)? e.pageY-theight : e.pageY) + ajaxtooltip.useroffset[1]
		$tooltip.css({left: tpositionx, top: tpositiony})
		$tooltip.hide()
		$tooltip.fadeIn('normal')
	}

}

$(document).ready(function(){
	ajaxtooltip.iebody=(document.compatMode && document.compatMode!="BackCompat")? document.documentElement : document.body
	var tooltips=[] //array to contain references to all tooltip DIVs on the page
	$('*[@title^="ajax:"]').each(function(index){ //find all links with "title=ajax:" declaration
		this.titleurl=jQuery.trim(this.getAttribute('title').split(':')[1]) //get URL of external file
		this.titleposition=index+' pos' //remember this tooltip DIV's position relative to its peers
		tooltips.push($('<div class="ajaxtooltip"></div>').appendTo('body'))
		var $target=$(this)
		$target.removeAttr('title')
		$target.hover(
			function(e){ //onMouseover element
				var $tooltip=tooltips[parseInt(this.titleposition)]
				if ($tooltip.html()==""){
					$tooltip.load(this.titleurl, '', function(){
						ajaxtooltip.positiontip($tooltip, e)		
					})
				}
				else{
					ajaxtooltip.positiontip($tooltip, e)
				}
			},
			function(e){ //onMouseout element
				var $tooltip=tooltips[parseInt(this.titleposition)]
					$tooltip.fadeOut('normal')		
			}
		)
	})
})