<%--
Copyright 2008 The MITRE Corporation (http://www.mitre.org/). All Rights Reserved.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
 --%>
<%@ page import="java.util.*"%>
<%@ page import="java.sql.*"%>
<%@ page import="org.mitre.mrald.util.*"%>
<%@ page import="org.mitre.neuroWeb.taglib.BrowseVolumesListTag"%>
<%@ page import="java.awt.*" %>
<%@ page contentType="text/html"%>
<%@ taglib uri="/WEB-INF/mrald.tld" prefix="mrald"%>
<%@ taglib uri="/WEB-INF/neuroWeb.tld" prefix="neuro"%>

<%

    int version = Integer.parseInt(WebUtils.getRequiredParameter(request, "version"));
    String[] orderBys = {
        BrowseVolumesListTag.ORDER_BY_GENDER,
        BrowseVolumesListTag.ORDER_BY_PI,
        BrowseVolumesListTag.ORDER_BY_SUBJECT_AGE,
        BrowseVolumesListTag.ORDER_BY_MODALITY};
    final String style_normal="background:#4088b8;color:#c8c8c8;";
    final String style_selected="background:#396db9;color:white;";

    final String[] styles={ version==0 ? style_selected : style_normal,
        version==1 ? style_selected : style_normal,
        version==2 ? style_selected : style_normal,
        version==3 ? style_selected : style_normal};
%>
<%-- <mrald:validate /> --%>
<%

    // User mraldUser = new User( "admin@mitre.org" );
    // request.getSession().setAttribute( Config.getProperty( "cookietag" ), null );
    // request.getSession().setAttribute( Config.getProperty( "cookietag" ), mraldUser );
    // Cookie c = new Cookie( Config.getProperty( "cookietag" ), "admin@mitre.org" );
    // c.setMaxAge( java.lang.Integer.MAX_VALUE / 2 );
    // response.addCookie( c );

    int cacheKiller = (int)(Math.random() * 1000);
    final String OPEN = "<%@ ";
    final String CLOSE =  "%" + ">";  //the jsp parser is having great difficulty with a % followed by a >..  This gets around that.
    final String title = OPEN + "include file='title.html'" + CLOSE;
%>
<html>
  <head>
   <% out.write(title); %>
</head>
<body>
<script type="text/javascript" src="checkboxToggle.js"></script>
<script language="JavaScript" src="overlib.js"></script>
<div id="wrap">

    <% out.write(OPEN + "include file='pageHeader.jsp'" + CLOSE); %>


<div id="content">
<h2><strong>Browse Images <span class="gray"></span></strong></h2>

        <center>
        <input type="button" style="<%=styles[0]%>" name="subject.gender" value="By Gender and Handedness" onclick="window.location='byGender.jsp?ck=<%=cacheKiller%>'; return true;"/>
        <input type="button" style="<%=styles[1]%>" name="project.pi_name" value="By PI Name" onclick="window.location='byLabNameSubject.jsp?ck=<%=cacheKiller%>'; return true;"/>
        <input type="button" style="<%=styles[2]%>" name="subject.birthdate" value="By Age of Subject " onclick="window.location='bySubjectAge.jsp?ck=<%=cacheKiller%>'; return true;"/>
        <input type="button" style="<%=styles[3]%>" name="volume.modality" value="By Modality" onclick="window.location='byModality.jsp?ck=<%=cacheKiller%>'; return true;"/>
          </center>
        <br /><br />
        <div name="chart"/>
        <br/>
        <form name="o" action="" method="POST">

        <%
        // System.out.println( orderBys[version] );
        switch(version)
        {
          case 0:
          %> Go to gender: <select name="navTo"><mrald:dropDownList datasource="main" table="subject" pkColumn="gender" listColumn="gender" /> <%
          break;
          case 1:
          %> Go to Lab: <select name="navTo"><mrald:dropDownList datasource="main" table="project" pkColumn="pi_name" listColumn="pi_name" /> <%
          break;
          case 2:
          %> Go to year: <select name="navTo"><mrald:dropDownList datasource="main" table="subject" pkColumn="birthdate" listColumn="birthdate" /> <%
          break;
          case 3:
          %>
          Go to modality: <select name="navTo"><mrald:dropDownList datasource="main" table="volume" pkColumn="modality" listColumn="modality" /> <%
          break;
          case 4:
	   %>
	   Go to metric: <select name="navTo"><mrald:dropDownList datasource="main" table="image_metrics" pkColumn="value" listColumn="value" /> <%
          break;
          default:
          %>  <option></option><%
        }
        %></select><input type="button" value="Go!" onclick="loc='#'+o.navTo.value;window.location=loc;"/>

        </center>

            <neuro:BrowseVolumes filter="" orderBy="<%=orderBys[version]%>"/>

	    <center>
                <input type="submit" style="background:#396db9;color:white;" value="View Selected Subjects" onclick="o.action='subject_info.jsp?get=subject_id'"/>
             </center>
        </form>

       <h2></h2>
    </div>
    <% out.write(OPEN+" include file='menus.jsp' " + CLOSE); %>
  </body>
</html>
