<%--
Copyright 2008 The MITRE Corporation (http://www.mitre.org/). All Rights Reserved.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
 --%>
<%@ page import="java.util.*"%><%@
    page import="java.sql.*"%><%@
    page import="de.laures.cewolf.*"%><%@
    page import="de.laures.cewolf.tooltips.*"%><%@
    page import="de.laures.cewolf.links.*"%><%@
    page import="org.jfree.data.*"%><%@
    page import="org.jfree.data.time.*"%><%@
    page import="org.jfree.data.gantt.*"%><%@
    page import="org.jfree.chart.*"%><%@
    page import="org.jfree.chart.plot.*"%><%@
    page import="org.jfree.data.category.*"%><%@
    page import="org.jfree.data.general.*"%><%@
    page import="org.jfree.data.xy.*"%><%@
    page import="org.mitre.mrald.util.*"%><%@
    page import="java.awt.*" %><%@
    page import="de.laures.cewolf.taglib.CewolfChartFactory" %>
    <%@ page import="org.jfree.data.xy.*"%>
    <%@ page import="org.jfree.chart.event.ChartProgressListener" %><%@
    page import="org.jfree.chart.event.ChartProgressEvent" %>
    <%@ page import="org.mitre.neuroWeb.ScatterDatasetProducer" %>
    <%@
    page contentType="text/html"%><%@
    taglib uri="/WEB-INF/cewolf.tld" prefix="cewolf" %>
    <%@ taglib uri="/WEB-INF/mrald.tld" prefix="mrald"%><%

      final int version = Integer.parseInt(WebUtils.getRequiredParameter(request, "version"));

    int CUTOFF = 10;
    if (version == 0)
    	CUTOFF =0;

    final String study = WebUtils.getOptionalParameter(request, "study");
    String xaxis = "";
    String filter;
    if( study==null || study.equals("") )
    {
        filter = "";
    }
    else
    {
        filter = "and p.grant_name='" + study + "'";
    }

    final String[] queries = {
        "SELECT DISTINCT gender, handedness, Count( volume.volume_id)  From project p, subject, volume, scan_event where subject.subject_oid = scan_event.subject_oid and volume.scan_id = scan_event.scan_id and p.project_id=subject.project_id " + filter + " GROUP BY gender, handedness ",
        "SELECT DISTINCT pi_name, Count( v.volume_id)  From project p, (select volume_id, scan_event.project_id  from subject, volume, scan_event where subject.subject_oid = scan_event.subject_oid and volume.scan_id = scan_event.scan_id) v where p.project_id = v.project_id " + filter + " GROUP BY pi_name",
        "SELECT DISTINCT subject.birthdate, Count(volume.volume_id)  From project p, subject, volume, scan_event where subject.subject_oid = scan_event.subject_oid and volume.scan_id = scan_event.scan_id and p.project_id=subject.project_id " + filter + " GROUP BY subject.birthdate",
        "SELECT DISTINCT volume.modality, Count( volume.volume_id)  From project p, subject, volume, scan_event where subject.subject_oid = scan_event.subject_oid and volume.scan_id = scan_event.scan_id and p.project_id=subject.project_id " + filter + " GROUP BY volume.modality "
    };

    final String style_normal="background:#4088b8;color:#c8c8c8;";
    final String style_selected="background:#396db9;color:white;";

    final String[] styles={ version==0 ? style_selected : style_normal,
        version==1 ? style_selected : style_normal,
        version==2 ? style_selected : style_normal,
        version==3 ? style_selected : style_normal,
	version==4 ? style_selected : style_normal};


	if ((version == 0)  )
	{
        ArrayList<String> seriesName = new ArrayList<String>();
	 	xaxis="Gender";

		DatasetProducer barChartData = new DatasetProducer()
		{
			Map dummy = new HashMap();
			java.util.Date dummyDate = new java.util.Date();
			public Object produceDataset(java.util.Map params)
			{

			    DefaultCategoryDataset ds = new DefaultCategoryDataset();

			    String query=queries[version];
			    try
			    {
				MraldConnection mconn = new MraldConnection();
				ResultSet rs = mconn.executeQuery(query);
				while(rs.next())
				{
				   String val1 = rs.getString(2);
				   if (val1== null)
				   {
				   	val1 = "Unknown";
				   }
				   String val2 = rs.getString(1);
				   if (val2== null)
				   {
				   	val2 = "Unknown";
				   }
				   int val3 = rs.getInt(3);
				   //Do not plot zero
				   if (val3 !=0)
				   	ds.setValue(val3,val1, val2);
				}
			    }
			    catch(Exception e)
			    {
				throw new RuntimeException(e);
			    }
			    return ds;
			}

			public String getProducerId()
			{
			     return "BarChartDataProducer";
			}

			public boolean hasExpired(java.util.Map params, java.util.Date since)
			{
			    return true;
			}
		};
		 pageContext.setAttribute("barChartData", barChartData);

		 LinkGenerator barLG = new CategoryItemLinkGenerator()
		    {
			public String generateLink(Object dataset, int test, Object category)
			{
			    StringBuffer ret = new StringBuffer( "" );
			    ret.append( "#" + category );
			    return ret.toString();
			}
		    };
		    pageContext.setAttribute("LinkGenerator", barLG);

		   ToolTipGenerator toolTipGenerator = new CategoryToolTipGenerator()
		    {
				public String generateToolTip(CategoryDataset ds, int seriesNo, int arg2)
				{
					return "Handedness = " + ds.getRowKey(seriesNo).toString() + " for " + ds.getValue(seriesNo, arg2) + " subjects"  ;
				}
		   };

	           pageContext.setAttribute("ToolTipGenerator", toolTipGenerator);
	}
	else if (version == 2)
	{
	  xaxis="Year of Birth";

	DatasetProducer barChartData = new DatasetProducer()
		{

			Map dummy = new HashMap();
			java.util.Date dummyDate = new java.util.Date();
			public Object produceDataset(java.util.Map params)
			{

			    DefaultCategoryDataset ds = new DefaultCategoryDataset();

			    String query=queries[version];
			    try
			    {
				MraldConnection mconn = new MraldConnection();
				ResultSet rs = mconn.executeQuery(query);
				while(rs.next())
				{
				   String val1 = rs.getString(1);
				   if (val1== null)
				   {
				   	val1 = "Unknown";
				   }

				   int val2 = rs.getInt(2);
				   //Do not plot zero
				   if (val2 !=0)
				   	ds.setValue(val2,val1,val1);
				}
			    }
			    catch(Exception e)
			    {
				throw new RuntimeException(e);
			    }
			    return ds;
			}

			public String getProducerId()
			{
			     return "BarChartDataProducer";
			}

			public boolean hasExpired(java.util.Map params, java.util.Date since)
			{
			    return true;
			}
		};

		 pageContext.setAttribute("barChartData", barChartData);

		  LinkGenerator barLG = new CategoryItemLinkGenerator()
		    {
			public String generateLink(Object dataset, int test, Object category)
			{
			    StringBuffer ret = new StringBuffer( "" );
			    ret.append( "#" + category );
			    return ret.toString();
			}
		    };
		    pageContext.setAttribute("LinkGenerator", barLG);

		   ToolTipGenerator toolTipGenerator = new CategoryToolTipGenerator()
		    {
				public String generateToolTip(CategoryDataset ds, int seriesNo, int arg2)
				{
					return ds.getRowKey(seriesNo).toString() + " has " + ds.getValue(seriesNo, arg2) + " subjects";
				}
		   };

	           pageContext.setAttribute("ToolTipGenerator", toolTipGenerator);
	}
	else if (version == 4)
	{
	  	xaxis="Image";

		ScatterDatasetProducer scatterChartData = new ScatterDatasetProducer(queries, version);
		XYToolTipGenerator tooltipGenerator = new XYToolTipGenerator() {
			public String generateToolTip(XYDataset data, int series, int item) {
				XYDataset dataset = (XYDataset) data;
				String imageName = dataset.getSeriesKey(series).toString();
				Double result = ((Double)dataset.getX(series,item)).doubleValue();
				return "Subject=" + imageName+ ",y="+ dataset.getY(series,item);
			}
		};

		XYItemLinkGenerator linkGenerator = new XYItemLinkGenerator() {
			 public String generateLink(Object data, int series, int item) {
			 	XYDataset dataset = (XYDataset) data;
			 	String imageName = dataset.getSeriesKey(series).toString();
				Double result = ((Double)dataset.getX(series,item)).doubleValue();
				return "subject_info.jsp?subject_id=" + imageName;
			 }
		};

		pageContext.setAttribute("tooltipGenerator", tooltipGenerator);
		pageContext.setAttribute("linkGenerator", linkGenerator);
		 pageContext.setAttribute("scatterChartData", scatterChartData);
		 pageContext.setAttribute("scatterLG", scatterChartData.getScatterLG());
		pageContext.setAttribute("scatterTP", scatterChartData.getScatterTP());

	}
	else
	{
		DatasetProducer pieData = new DatasetProducer()
		{
			Map dummy = new HashMap();
			java.util.Date dummyDate = new java.util.Date();
			public Object produceDataset(java.util.Map params)
			{
			    DefaultPieDataset ds = new DefaultPieDataset();
			    String query=queries[version];
			    try
			    {
				MraldConnection mconn = new MraldConnection();
				ResultSet rs = mconn.executeQuery(query);
				while(rs.next())
				{
				 String val = rs.getString(1);
				   if (val== null)
				   {
				   	val = "Unknown";
				   }

				    ds.setValue(val,  rs.getInt(2));
				}
			    }
			    catch(Exception e)
			    {
				throw new RuntimeException(e);
			    }
			    return ds;
			}

			public String getProducerId()
			{
			     return "PieDataProducer";
			}

			public boolean hasExpired(java.util.Map params, java.util.Date since)
			{
			    return true;
			}
	    };
	    pageContext.setAttribute("pieData", pieData);

	    LinkGenerator pieLG = new PieSectionLinkGenerator()
	    {
		public String generateLink(Object dataset, Object category)
		{
		    StringBuffer ret = new StringBuffer( "" );
		    ret.append( "#" + category );
		    return ret.toString();
		}
	    };
	    pageContext.setAttribute("pieLG", pieLG);
     }

// User mraldUser = new User( "admin@mitre.org" );
// request.getSession().setAttribute( Config.getProperty( "cookietag" ), null );
// request.getSession().setAttribute( Config.getProperty( "cookietag" ), mraldUser );
// Cookie c = new Cookie( Config.getProperty( "cookietag" ), "admin@mitre.org" );
// c.setMaxAge( java.lang.Integer.MAX_VALUE / 2 );
// response.addCookie( c );

if  ((version == 0) || (version ==2))
{
%>
	<cewolf:chart id="barChart" type="stackedverticalbar3d" legendanchor="south" showlegend="true" xaxislabel="<%=xaxis%>">
	    <cewolf:gradientpaint>
		<cewolf:point x="0" y="0" color="#EFEEFD" />
		<cewolf:point x="500" y="0" color="#EFEEFD" />
	    </cewolf:gradientpaint>
	    <cewolf:data>
		<cewolf:producer id="barChartData">
		    <%-- <cewolf:param name="query" value="" /> --%>
		</cewolf:producer>
	    </cewolf:data>
	</cewolf:chart>
	<center>

	<cewolf:img chartid="barChart" renderer="/cewolf" width="700" height="450">
	<cewolf:map linkgeneratorid="LinkGenerator"  tooltipgeneratorid="ToolTipGenerator"  />

	</cewolf:img>
<%
}
else if ((version == 4) )
{
%>
<cewolf:chart id="scatterChart" type="scatter" legendanchor="south" showlegend="false">
    <cewolf:gradientpaint>
        <cewolf:point x="0" y="0" color="#EFEEFD" />
        <cewolf:point x="500" y="0" color="#EFEEFD" />
    </cewolf:gradientpaint>
    <cewolf:data>
        <cewolf:producer id="scatterChartData">
            <%-- <cewolf:param name="query" value="" /> --%>
        </cewolf:producer>
    </cewolf:data>
</cewolf:chart>

<cewolf:img chartid="scatterChart" renderer="/cewolf" width="700" height="450">
	 <cewolf:map linkgeneratorid="linkGenerator"  tooltipgeneratorid="tooltipGenerator"  />
</cewolf:img>

<center>

<%
}
else {
%>
<cewolf:chart id="pieChart" type="pie3D" legendanchor="south" showlegend="false">
    <cewolf:gradientpaint>
        <cewolf:point x="0" y="0" color="#EFEEFD" />
        <cewolf:point x="500" y="0" color="#EFEEFD" />
    </cewolf:gradientpaint>
    <cewolf:data>
        <cewolf:producer id="pieData">
            <%-- <cewolf:param name="query" value="" /> --%>
        </cewolf:producer>
    </cewolf:data>
</cewolf:chart>
<center>

<cewolf:img chartid="pieChart" renderer="/cewolf" width="700" height="450">
      <cewolf:map linkgeneratorid="pieLG"/>
</cewolf:img>

<%}%>
