<%--
Copyright 2008 The MITRE Corporation (http://www.mitre.org/). All Rights Reserved.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
 --%>
<%-- This jsp grabs the scan and interview events for the passed subject and date +/- one day --%>
<%@ page import="org.mitre.mrald.util.*,java.sql.*" %>
<%@ taglib prefix="tags" tagdir="/WEB-INF/tags" %>
<%
    try{
        String subjectID = WebUtils.getRequiredParameter(request, "subject_id");
        String date = WebUtils.getOptionalParameter(request, "date");
        MraldConnection conn = new MraldConnection("main");
        ResultSet rs =null;
        String query = null;
        if( date == null || date.equals("") )
        {
            query = "select max(scan_date) from scan_event natural join subject" +
                " WHERE subject.subject_id = '" + subjectID + "'" +
                " union " +
                " select max(date)" +
                " from subject_values natural join subject " +
                " WHERE subject.subject_id = '" + subjectID + "'" +
                " order by 1 desc ";
            rs=conn.executeQuery(query);
            if( rs.next() )
            {
                date = rs.getString(1);
                out.println("Latest scan and/or interview information:<br/>");
            }
            else
            {
                out.println("No scans or interviews for this subject.");
            }
        }
        // do the scans first
        query = "select scan_date, modality, xresolution, yresolution, zresolution, xfov, yfov, zfov " +
            " from scan_event natural join subject natural join volume " +
            " where scan_date between date '" + date + "' - 1 " +
            " and date '" + date + "' + 1 " +
            " and subject_id='" + subjectID + "' ";
        rs=conn.executeQuery(query);
        showScans( rs, out );
        rs.close();

        //next do the interviews
        query = "select distinct  v.date, e.name as ename, a.name as aname, v.value, s.subject_id " +
            "from subject_values v natural join attribute a join entity e on a.entity_id = e.entity_id join subject s on s.subject_oid = v.subject_oid " +
            "where v.date between date '" + date + "' - 1 " +
            " and date '" + date + "' + 1 " +
            " and subject_id='" + subjectID + "' order by e.name, a.name";
        rs=conn.executeQuery(query);
        showInterviews( date, rs, out );
        rs.close();

        conn.close();
    }
    catch (Exception e)
    {
        MraldOutFile.logToFile( e );
        out.println("An error occurred in retireving this information.");
    }
%>

<%-- class level functions --%>
<%!
    private void showScans( ResultSet rs, JspWriter out )
    throws Exception
    {
        while(rs.next())
        {
            out.println("<div style=\"float:right\"><img src=\"images/2000505_9_1_preview1.png\"/><br/><img src=\"images/2000505_9_1_preview2.png\"/><br/><img src=\"images/2000505_9_1_preview3.png\"/></div>");
            out.println("Scan Date: " + rs.getString(1) );
            out.println("<br/>Modality: " + rs.getString(2) );
            // out.println("<br/>Diagnosis: " + rs.getString(9) );
            out.println("<br/>x-resolution: " + rs.getString(3) );
            out.println("mm<br/>y-resolution: " + rs.getString(4) );
            out.println("mm<br/>z-resolution: " + rs.getString(5) );
            out.println("mm<br/>x-FOV: " + rs.getString(6) );
            out.println("mm<br/>y-FOV: " + rs.getString(7) );
            out.println("mm<br/>z-FOV: " + rs.getString(8) );
            out.println("mm<br clear=\"all\"/><hr/>");
        }
    }

    private void showInterviews( String date, ResultSet rs, JspWriter out )
    throws Exception
    {
        String lastEname="NO ENTITY NAMED THIS";
        String thisEname = null;
        boolean first = true;
        while(rs.next())
        {
            thisEname = rs.getString("ename");
            if( !thisEname.equals(lastEname) )
            {
                if(!first) out.println( "<br/>" );
                first = false;
                out.println( thisEname + " (recorded " + date + ")");
                lastEname=thisEname;
            }
            out.println("<li>" + rs.getString("aname") + ": " + rs.getString("value") + "</li>" );
        }
    }

%>
