/*
 *  Copyright 2008 The MITRE Corporation (http://www.mitre.org/). All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package org.mitre.lattice.custom;

import java.util.ArrayList;

import org.mitre.lattice.lattice.LatticeNode;
import org.mitre.lattice.lattice.LatticeTree;

/**
 *  This LatticeNode class acts as a node on the LatticeTree structure. Each of
 *  these LatticeNodes on the LatticeTree identifies a Community of Interest
 *  (COI) and eventually this will be tied to the label of images and users in
 *  the MITRE Lattice Security package.
 *
 *@author     Gail Hamilton, ghamilton@mitre.org, The MITRE Corporation
 *@created    December 15, 2003
 *@see        LatticeTree
 *@version    1.0
 */
public class DefaultNode extends LatticeNode
{

	/*
	 *  The children and parent arrays are the list of the
	 *  associated parents and children with that particular node
	 */

	/**
	 *  Constructs a new LatticeNode instance with the name, children, and parents
	 *  set to null
	 */
/*	public DefaultNode()
	{
		super();
	}*/


	/**
	 *  Constructs a new LatticeNode instance with the name, equal to the specific
	 *  name and the children and parents set to null
	 *
	 *@param  nodeName  The name to be assigned to this LatticeNode
	 */
	public DefaultNode(String nodeName)
	{
		super(nodeName);

	}


	/**
	 *  Constructs a new LatticeNode instance with the name, children and parents
	 *  set to the specified values
	 *
	 *@param  nodeName  The name to be assigned to this LatticeNode
	 *@param  children  The ArrayList of LatticeNodes that will be assigned to this
	 *      LatticeNode's children
	 *@param  parents   The ArrayList of LatticeNodes that will be assigned to this
	 *      LatticeNode's parents
	 */
	public DefaultNode(String nodeName, ArrayList<LatticeNode> children, ArrayList<LatticeNode> parents)
	{
		super(nodeName, children, parents);
	}


	/**
	 *  Constructs a new LatticeNode instance with the name, children and parents
	 *  set to the values of the specified LatticeNode argument.
	 *
	 *@param  newNode  The LatticeNode that will be used as the source of the
	 *      values for the new LatticeNode
	 */
	public DefaultNode(LatticeNode newNode)
	{

		super( newNode);
	}

	/**
	 *  Constructs a new LatticeNode instance with the name, children and parents
	 *  set to the values of the specified LatticeNode argument.
	 *
	 *@param  newNode  The LatticeNode that will be used as the source of the
	 *      values for the new LatticeNode
	 *@param  isCopy   Description of the Parameter
	 */
	public DefaultNode(LatticeNode newNode, boolean isCopy)
	{

		super(newNode.getName());
	}

}

