/*
 *  Copyright 2008 The MITRE Corporation (http://www.mitre.org/). All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package org.mitre.lattice.eav;

import java.net.URLEncoder;
import java.sql.ResultSet;
import java.sql.SQLException;

import org.mitre.mrald.util.MraldException;
/**
 *@author     Gail Hamilton
 *@created
 *@version    1.0
 *@see        java.lang.Object
 */
public class AttributeElement extends EavElement
{
	/**
	 *  Description of the Field
	 */

	 private static String SPACER = "<img alt=\"\" src=\"images/spacer.gif\" width=\"50\" height=\"1\"/>";
	 private static String INTRASPACER = "<img alt=\"\" src=\"images/spacer.gif\" width=\"15\" height=\"1\"/>";

	/**
	 *  Constructor for the QueryElements object
	 *
	 *@since
	 */
	public AttributeElement()  throws MraldException
	{
		super(new String("Attribute"));
	}


	/**
	 */
	protected void init() throws MraldException
	{
		//Set up the query that will be used to return the results


			if (getDisplayColumn().equals(""))
			{
				setInitQuery("SELECT * FROM Attribute ");
			} else
			{
				setColCount(1);
				setInitQuery(" SELECT " + getDisplayColumn() + ",attribute_id from Attribute ");
			}
			setColName("attribute_id");


	}


	/**
	 *@param  columnNo            Description of the Parameter
	 *@return                     The HTML for inclusion in the second form
	 *      building page.
	 *@exception  MraldException  Description of the Exception
	 */
	protected StringBuffer outputRow(int columnNo) throws MraldException
	{
		try
		{
			if (!isTable)
				return outputRowNonTable(columnNo);

			StringBuffer ret = new StringBuffer();

			//ret.append("<table summary=\"\" width=\"100%\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\"><center>");
			ret.append("<tr>");
			for (int i = 1; i < columnNo + 1; i++)
			{
				if (getPrintVert())
				{
					ret.append("<tr>");

				}

				ret.append("<td>" + getRs().getString(i) + "</td>");

				if (getPrintVert())
				{
					ret.append("</tr>");

				}
			}
			ret.append("</tr>");

			//ret.append("</center></table>");
			return ret;
		} catch (SQLException s)
		{
			throw new MraldException(s);
		}
	}


	/**
	 *@param  columnNo            Description of the Parameter
	 *@return                     The HTML for inclusion in the second form
	 *      building page.
	 *@exception  MraldException  Description of the Exception
	 */
	protected StringBuffer outputRowNonTable(int columnNo) throws MraldException
	{
		try
		{
			StringBuffer ret = new StringBuffer();

			ret.append( SPACER);
			for (int i = 1; i < columnNo + 1; i++)
			{
				/*if (getPrintVert())
				{
					ret.append("<p class=\"sideBarTitle\">");
				}*/

				if (columnNo == 1)
				{

					ret.append(SPACER + "<a href='eavFrame.jsp?classType=" + getType() + "&colName=" + URLEncoder.encode(getColName() ,"UTF-8") + "&colValue=" + URLEncoder.encode(getRs().getString(getColName()),"UTF-8") + "' target=\"_parent\">" + getRs().getString(i) + "</a>");
					hasDiv = true;
				}
				else
				{
					ret.append( getRs().getString(i) + INTRASPACER) ;
				}

				if (getPrintVert())
				{
						//ret.append("</p>");
						ret.append("<br/>");
				}

			}
			if (hasDiv)
			{

				   ret.append(SPACER + "<a onClick=\"toggleNonId(this)\" ><img src=\"images/plus.gif\"></a><div style=\"display:none;\" class=\"leftSideBar\">");
				   endSection="</div></p>";

			}
			else
			{
				ret.append("<br/>");
			}
			setColValue(getRs().getString(getColName()));
			return ret;

		} catch (SQLException s)
		{
			throw new MraldException(s);
		}
		catch (java.io.UnsupportedEncodingException s)
		{
			throw new MraldException(s);
		}
	}
	/**
	 *@return                     The HTML for inclusion in the second form
	 *      building page.
	 *@exception  MraldException  Description of the Exception
	 */
	public String insertHtml() throws MraldException
	{
		try
		{
			/*
			 *  prebuild the drop down lists
			 *  they'll be modified later for the specific drop downs
			 */
			setColCount(2);

			int id = 0;
			if ((!getColName().equals("")) && (!getColValue().equals("")))
			{
			  setInitQuery("SELECT Max(attribute_id) + 1 FROM Attribute ");
			  //setParams(getColName(), getColValue());

			  ResultSet rs = runQuery(getQuery());

			  if (rs.next())
			  {
				id = rs.getInt(1);
			  }
			  rs.close();
			}

			StringBuffer ret = new StringBuffer();

			String[] columns = new String[]{"attribute_id", "name", "description", "entity_id", "units"};
			String[] columnNames = new String[]{"Attribute Id", "Name", "Description", "Entity Id", "Units"};

			String tableName = "attribute";
			for (int i = 0; i < columns.length; i++)
			{
				String value = "";
				if (i == 0)
				{
					value = id + "";
				}

				if (getColName().equals(columns[i]))
				{
					value = getColValue();
				}

				String input = "<tr><td><b>" + columnNames[i] + "</b></td><td><input type=\"text\" length=\"30\" name=\"Insert" + i +
					"\" value=\"" + value + "\"/><input type=\"hidden\" value=\"Table:" + tableName + "~Field:" + columns[i] + "~Order:" + i + "~Type:String\" name=\"Insert" + i + "\"/><br/></td></tr>";

				if (columns[i].equals("description"))
				{
					input = "<tr><td><b>" + columnNames[i] + "</b></td><td><textarea rows=\"3\" cols=\"60\" wrap=\"soft\" name=\"Insert" + i + "\"></textarea>" +
					"<input type=\"hidden\" value=\"Table:" + tableName + "~Field:" + columns[i] + "~Order:" + i + "~Type:String\" name=\"Insert" + i + "\"/><br/></td></tr>";

				}
				ret.append(input);
			}
			this.close();
			return ret.toString();
		} catch (SQLException e)
		{
			throw new MraldException();
		}
	}


	/**
	 *@return    The HTML for inclusion in the second form building page.
	 */
	public String deleteHtml()
	{
		/*
		 *  prebuild the drop down lists
		 *  they'll be modified later for the specific drop downs
		 */
		StringBuffer ret = new StringBuffer();

		return ret.toString();
	}


	/**
	 *@return    The HTML for inclusion in the second form building page.
	 */
	public String updateHtml()
	{
		/*
		 *  prebuild the drop down lists
		 *  they'll be modified later for the specific drop downs
		 */
		StringBuffer ret = new StringBuffer();

		return ret.toString();
	}

}

