/*
 *  Copyright 2008 The MITRE Corporation (http://www.mitre.org/). All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package org.mitre.lattice.graph;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.Transparency;
import java.awt.image.BufferedImage;

import javax.swing.ImageIcon;

import org.mitre.mrald.util.Config;
import org.mitre.mrald.util.MraldError;
import org.mitre.mrald.util.MraldOutFile;
/**
 *  This LatticeNode class acts as a node on the LatticeTree structure. Each of
 *  these LatticeNodes on the LatticeTree identifies a Community of Interest
 *  (COI) and eventually this will be tied to the label of images and users in
 *  the MITRE Lattice Security package.
 *
 *@author     Gail Hamilton, ghamilton@mitre.org, The MITRE Corporation
 *@created    November 5, 2003
 *@see        ImageConvertor
 *@version    1.0
 */
public class ImageConvertor extends Object
{

    /**
     *  Constructor for the ImageConvertor object
     */
    public ImageConvertor() { }


    /**
     *  Description of the Method
     *
     *@param  image  Description of the Parameter
     *@return        Description of the Return Value
     */
    public static BufferedImage convertToBufferedImage( Image image )
    {
        try
        {
        if (image == null) return null;

        BufferedImage bimage = null;
            GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        if ( GraphicsEnvironment.isHeadless())
        {
           MraldOutFile.logToFile( Config.getProperty( "LOGFILE"),"Running in Graphics Headless Mode " );
        }
        else
        {
            //MraldOutFile.logToFile( Config.getProperty( "LOGFILE"),"Not Running in Graphics Headless Mode " );
        }

            if ( image instanceof BufferedImage )
            {
                return ( ( BufferedImage ) image );
            }
            image = new ImageIcon( image ).getImage();

            boolean hasAlpha = hasAlpha( image );

            int transparency = Transparency.OPAQUE;
            if ( hasAlpha )
            {
                transparency = Transparency.BITMASK;
            }

            GraphicsDevice gs = ge.getDefaultScreenDevice();
            GraphicsConfiguration gc = gs.getDefaultConfiguration();

            bimage = gc.createCompatibleImage( image.getWidth( null ), image.getHeight( null ), transparency );

            if ( bimage == null )
            {
                int type = BufferedImage.TYPE_INT_RGB;
                if ( hasAlpha )
                {
                    type = BufferedImage.TYPE_INT_ARGB;
                }
                bimage = new BufferedImage( image.getWidth( null ), image.getHeight( null ), type );
            }
            Graphics g = bimage.createGraphics();

            //Paint the image onto the Buffered Image

            g.drawImage( image, 0, 0, null );
            g.dispose();

            return bimage;
    }
        catch ( HeadlessException e )
        {
            //NO screen
            MraldOutFile.logToFile( Config.getProperty( "LOGFILE"),"Headless Mode " );
        }catch(Exception e)
        {
            throw new MraldError(e);
        }

        return null;
    }


    /**
     *  Description of the Method
     *
     *@param  image  Description of the Parameter
     *@return        Description of the Return Value
     */
    public static boolean hasAlpha( Image image )
    {
        return false;
    }

}

