/*
 *  Copyright 2008 The MITRE Corporation (http://www.mitre.org/). All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package org.mitre.lattice.lattice;

public interface LatticeTreeInterface {

	/* The root_node acts as the base of operations
	 * for a tree. It will be either the 'Public' node
	 * or the base for each of the sites (MITRE, UCLA, etc.)
	 */
	/*final LatticeNode root_node;*/

	/* getRootNode() will return the root node of the tree */
	public LatticeNode getRootNode();

	/* dominates() takes a Node and returns the string
	 * array of all of the nodes that the given Node
	 * dominates, or is above in the Lattice structure
	 */
	public java.util.ArrayList dominates( LatticeNode keyNode );


	/* importTree() takes a LatticeTree structure and attempts
	 * to include it into this tree.  If the import is successful
	 * tit returns a true, and it returns false otherwise.
	 *
	 * Potential: Throws a DESCRIPTIVE exception as to the reason
	 * for the import failure.
	 */
	public boolean importTree( LatticeTree keyTree );
	/* exportTree() sends this tree to the client system. */
	public LatticeTree exportTree();


	/* equals() compares the given tree with this tree and returns
	 * true if equal, false if not.
	 */
	public boolean equals( LatticeTree testTree );
	/* NOT SURE WHAT THIS IS SUPPOSED TO DO. */

	public int hash( LatticeTree testTree );


	/* addNode() is the public interface for adding nodes to the
	 * tree.  You add by passing a name, which will be the label for
	 * the node, and an array of the intended parents and children.
	 * The logic is going to handled in the LatticeNode class.
	 *
	 * If parents is NULL, we dont care.  This is permissible.
	 *
	 * If children is NULL, we add the root_node of the tree to
	 * the children list.
	 *
	 * The function will return true if the process completes
	 * successfully, and false otherwise.
	 */
	public boolean addNode( String name, java.util.ArrayList<LatticeNode> nodeParents, java.util.ArrayList<LatticeNode> nodeChildren ) throws InvalidLatticeStructureException;
	/* removeNode() is the public interface that will deal with
	 * the removal of a node from the tree.
	 * The logic will be handled in the LatticeNode class.
    *
	 * The function will return true if the process completes
	 * successfully, and false otherwise.
	 */
	public boolean removeNode( String name );


	/* checkTree() will check the integrity of the tree strucutre
	 * itself.
	 *
	 * The function will return true if the process completes
	 * successfully, and false otherwise.
	 */
	public boolean checkTree();


	/* searchTree() will be the search tool for a specific node in
	 * the tree. The function will return of the nodes dominated
	 * by the search key.
	 */
	public LatticeNode[] searchTree( LatticeNode keyNode ) throws NodeNotFoundException;

}


