/*
 *  Copyright 2008 The MITRE Corporation (http://www.mitre.org/). All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package org.mitre.lattice.taglib;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;

import javax.servlet.jsp.JspException;

import org.mitre.lattice.query.LatticeQuery;
import org.mitre.mrald.taglib.ListUpdateValuesTag;
import org.mitre.mrald.util.Config;
import org.mitre.mrald.util.MraldException;
import org.mitre.mrald.util.User;
/**
 *  Description of the Class
 *
 *@author     jchoyt
 *@created    October 9, 2002
 */
public class LatticeListUpdateValuesTag extends ListUpdateValuesTag
{

	/**
	 *  Constructor for the AllTablesListTag object
	 */
	public LatticeListUpdateValuesTag() { }


	/**
	 *  Initializes the streams and database connections.
	 *
	 *@param  selectClause      Description of the Parameter
	 *@param  tableName         Description of the Parameter
	 *@param  pks               Description of the Parameter
	 *@param  fks               Description of the Parameter
	 *@return                   Description of the Return Value
	 *@exception  SQLException  Description of the Exception
	 *@exception  JspException  Description of the Exception
	 */
	public String outputResults(String datasource, String selectClause, String tableName, ArrayList pks, HashMap fks) throws SQLException, JspException
	{

		try
		{
		User user = (User) pageContext.getSession().getAttribute(Config.getProperty("cookietag"));

//		StringBuffer buffer = new StringBuffer();

//		LatticeQuery latQuery = new LatticeQuery();

		String queryAdd = LatticeQuery.adaptQuery(selectClause, user);
		selectClause = queryAdd;


		return super.outputResults(datasource, selectClause,tableName,  pks,  fks);
		}
		catch (MraldException e)
		{
			JspException se = new JspException(e.getMessage());
			se.fillInStackTrace();
			throw se;
		}
	}



}

