/*
 *  Copyright 2008 The MITRE Corporation (http://www.mitre.org/). All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package org.mitre.lattice.taglib;

import java.io.IOException;

import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.TagSupport;

import org.mitre.mrald.util.Config;
import org.mitre.mrald.util.User;

/**
 *  Description of the Class
 *
 *@author     jchoyt
 *@created    September 1, 2003
 */
public class ShowCOITag extends TagSupport
{
    /**
     *  Description of the Method
     *
     *@return                   Description of the Return Value
     *@exception  JspException  Description of the Exception
     */
    public int doStartTag() throws JspException
	{
		User mraldUser = (User) pageContext.getSession().getAttribute(Config.getProperty("cookietag"));
		String coi = mraldUser.getGroup();

        StringBuffer ret = new StringBuffer();
        ret.append( "<table width=\"200\" border=\"1\">");
		ret.append("<tr>\n<hr width=\"200\"><td align=\"center\"> Current COI : <b>" + coi + "</b></td></table>");

        try
        {
            pageContext.getOut().print( ret.toString() );
        }
        catch ( IOException e )
        {
            throw new JspException( "IO Error: " + e.getMessage() );
        }

        return 0;
    }
}

