/*
 *  Copyright 2008 The MITRE Corporation (http://www.mitre.org/). All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package org.mitre.lattice.util;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Properties;

import org.mitre.lattice.lattice.LatticeTree;
import org.mitre.mrald.util.Config;
import org.mitre.mrald.util.MiscUtils;
/**
 * THis class contains a list of all the static variables that are used within
 * neuroinformatics
 *
 *@author     Gail Hamilton, ghamilton@mitre.org, The MITRE Corporation
 *@created    December 15, 2003
 *@see        LatticeTree
 *@version    1.0
 */
public abstract class Constants
{

     protected static Properties PROPS =  null;

     private static PropertyChangeListener pcl;

     public static String[] nodeTypes = null;
     /**
     *  Constructor for the StagedPageParser object
     *
     *@since
     */
    public Constants()
    {
	    init();
    }
     /**
     *  Description of the Method
     */
    public static void init()
    {
	//MraldOutFile.logToFile( Config.getProperty("LOGFILE"), "Constants: . Init");

        if (PROPS ==null || nodeTypes ==null || pcl == null)
	{
	//MraldOutFile.logToFile( Config.getProperty("LOGFILE"), "Constants: . calling property change");
	loadProperties();
        pcl = (
            new PropertyChangeListener()
            {
                public void propertyChange( PropertyChangeEvent evt )
                {
                    loadProperties();
                }
            } );
	}
    }

     /**
     *  Loads the properties from permanent storage. Uses a call to the MRALD
     *  global configuration to get the location of this file. After the
     *  properties are loaded, the keys are stored in a Vector to make retrieval
     *  easier and faster.
     *
     *@since
     */
    public static void loadProperties()
    {
	    PROPS = MiscUtils.loadProperties( Config.getProperty( "latticeProps" ) );

    }

    public static void setNodeTypes(String[] theseNodeTypes)
    {
	    nodeTypes = theseNodeTypes;
    }

    public static String[] getNodeTypes()
    {
	    return nodeTypes;
    }

    /**
     *  Loads the properties from permanent storage. Uses a call to the MRALD
     *  global configuration to get the location of this file. After the
     *  properties are loaded, the keys are stored in a Vector to make retrieval
     *  easier and faster.
     *
     *@since
     */
    public static Properties getProperties()
    {
        return PROPS;
    }
}
