/*
 *  Copyright 2008 The MITRE Corporation (http://www.mitre.org/). All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.mitre.mrald.analysis;

import org.mitre.mrald.control.MsgObject;
import org.mitre.mrald.parser.MraldParserException;
import org.mitre.mrald.parser.ParserElement;
import org.mitre.mrald.util.FormTags;
import org.mitre.mrald.util.MraldError;

public class AnalysisElement extends ParserElement
{
    protected String elementType;
    protected String field;
    protected String order;
    protected String type;
    protected String format;

    public AnalysisElement()
    {
        nameValues = new MsgObject();
        elementType = "Analysis";
    }

    public AnalysisElement( MsgObject thisMsg )
    {
        nameValues = thisMsg;
        elementType = "Analysis";
    }

    public String getElementType()
    {
        return elementType;
    }

    public String getField()
    {
        return field;
    }

    public String getFormat()
    {
        return format;
    }

    public MsgObject getNameValues()
    {
        return nameValues;
    }

    public String getType()
    {
        return type;
    }

    public String getOrder()
    {
        return order;
    }

	public String[] getValues()
	{
		return nameValues.getValue( FormTags.VALUE_TAG );
	}

    public String preProcess( MsgObject msg, String currentName )
        throws MraldParserException
    {
        return currentName;
    }

    public void process( String[] valueList )
        throws MraldParserException
    {
        try
        {
            super.process( valueList );
        }
        catch (MraldParserException e)
        {
            throw new MraldError(e);
        }

        init();
    }

    protected void setField()
    {
        field = nameValues.getValue( FormTags.FIELD_TAG )[0];
    }

    protected void setFormat()
    {
        format = nameValues.getValue( FormTags.FORMAT_TAG )[0];
    }

    protected void setOrder()
    {
        order = nameValues.getValue( FormTags.ORDER_TAG )[0];
    }

    protected void setType()
    {
        type = nameValues.getValue( FormTags.TYPE_TAG )[0];
    }

    protected void init()
    {
        setField();
        setFormat();
        setType();
        setOrder();
    }
}

