/*
 *  Copyright 2008 The MITRE Corporation (http://www.mitre.org/). All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.mitre.mrald.analysis;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;

import org.mitre.mrald.control.MsgObject;
import org.mitre.mrald.control.MsgObjectException;


public abstract class MitreAnalysis extends AnalysisManager
{
    public MitreAnalysis() {
		super();
	}

    protected void prepareHeaders( MsgObject msg ) throws AnalysisManagerException
    {
        try
        {
            msg.SetOutPrintWriter();
			msg.setContentType( "text/plain" );
			msg.setHeader( "Content-Disposition", "inline;" );
        }
        catch ( MsgObjectException mge )
        {
            AnalysisManagerException aee = new AnalysisManagerException( mge.getMessage() );
            throw aee;
        }
    }

    protected String makeTemplateFile() throws AnalysisManagerException
    {
		try
		{
			String fileLocation = msg.getUserId() + System.currentTimeMillis() + ".template";
			FileOutputStream fout = new FileOutputStream( new File( System.getProperty( "java.io.tmpdir" ) + "/" + fileLocation ) );
			AnalysisElement currentElement = null;
			String formattedString;

			for ( int k = 0; k < sortedElements.size(); k++ )
			{
				currentElement = sortedElements.get( k );

				formattedString = "";

				if ( currentElement.getType().equals( "Nominal" ) )
				{
					formattedString = currentElement.getField() + ": nominal ";
					formattedString += currentElement.getValues().length + "\n";
				}

				else if ( currentElement.getType().equals( "Continuous" ) )
					formattedString = currentElement.getField() + ": continuous\n";

				else if ( currentElement.getType().equals( "Ordered" ) )
					formattedString = currentElement.getField() + ": ordered\n";

				else if ( currentElement.getType().equals( "Ignore" ) )
					formattedString = currentElement.getField() + ": ignore\n";

				fout.write( formattedString.getBytes() );
			}

			fout.close();
			return System.getProperty( "java.io.tmpdir" ) + "/" + fileLocation;
		}
		catch ( FileNotFoundException fnfe )
		{
			throw new AnalysisManagerException( fnfe );
		}
		catch ( IOException ioe )
		{
			throw new AnalysisManagerException( ioe );
		}
    }

    protected abstract void performAnalysis( String template_file, String data_file ) throws AnalysisManagerException;

    protected abstract void displayResults() throws AnalysisManagerException;
}

