/*
 *  Copyright 2008 The MITRE Corporation (http://www.mitre.org/). All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.mitre.mrald.analysis;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.SequenceInputStream;

import org.mitre.mrald.util.*;

import weka.classifiers.Evaluation;
import weka.classifiers.trees.J48;
import weka.core.Instances;

public class WekaJ48 extends WekaAnalysis
{
	protected J48 scheme;
	protected Evaluation evaluator;

    public WekaJ48() {
		super();
	}

    protected void performAnalysis( String template_file, String data_file ) throws AnalysisManagerException
    {
		try
		{
			scheme = new J48();
			SequenceInputStream sis = new SequenceInputStream( new FileInputStream( template_file ), new FileInputStream( data_file ) );
			Instances data = new Instances( new InputStreamReader( sis ) );
			data.setClassIndex( Integer.parseInt( (msg.getValue( "focused_field" ))[0] ) );
			scheme.buildClassifier( data );
			Evaluation evaluator = new Evaluation( data );
			evaluator.evaluateModel( scheme, data );
		}
		catch ( FileNotFoundException fnfe )
		{
			throw new AnalysisManagerException( fnfe );
		}
		catch ( IOException ioe )
		{
			throw new AnalysisManagerException( ioe );
		}
		catch ( Exception e )
		{
			MraldOutFile.logToFile( MiscUtils.formatThrowable(e) );
			throw new AnalysisManagerException( e );
		}
    }

    protected void displayResults() throws AnalysisManagerException
    {
		try
		{
			PrintWriter out = msg.getOutPrintWriter();
			out.println( evaluator.toSummaryString() );
			out.println( evaluator.toClassDetailsString() );
			out.println( evaluator.toMatrixString() );
//			out.println( "Error Rate: " + evaluator.errorRate() );
//			out.println( "Prefix: " + scheme.prefix() );
		}
		catch ( Exception e )
		{
			throw new AnalysisManagerException( e );
		}

    }
}

