/*
 *  Copyright 2008 The MITRE Corporation (http://www.mitre.org/). All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */package org.mitre.mrald.query;

import org.w3c.dom.*;

import java.net.*;


/**
 * DOCUMENT ME!
 *
 * @author $author$
 * @version $Revision: 1.2 $
 */
public class BroadcastQueryTarget
{
    /** Name property. */
    protected String name = null;

    /** LocalDatasource property. */
    protected String localDatasource = null;

    /** RemoteDatasource property. */
    protected String remoteDatasource = null;

    /** Url property. */
    protected URL url = null;

    /** SqlElements property. */
    protected SqlElements[] sqlElements = new SqlElements[0];

    /** LinkElements property. */
    protected LinkElement[] linkElements = new LinkElement[0];

    /**
     * Get sqlElements property.
     *
     * @return SqlElements property.
     */
    public SqlElements[] getSqlElements(  )
    {
        return this.sqlElements;
    }

    /**
     * Set sqlElements property.
     *
     * @param sqlElements New sqlElements property.
     */
    public void setSqlElements( SqlElements[] sqlElements )
    {
        this.sqlElements = sqlElements;
    }

    /**
     * Get linkElements property.
     *
     * @return LinkElements property.
     */
    public LinkElement[] getLinkElements(  )
    {
        return this.linkElements;
    }

    /**
     * Set linkElements property.
     *
     * @param linkElements New linkElements property.
     */
    public void setLinkElements( LinkElement[] linkElements )
    {
        this.linkElements = linkElements;
    }

    /**
     * For debugging purposes
     *
     * @return DOCUMENT ME!
     */
    public String toString(  )
    {
        StringBuilder ret = new StringBuilder(  );
        ret.append( "Name: " + name );
        ret.append( "\nLocal Datasource: " + localDatasource );
        ret.append( "\nRemote Datasource: " + remoteDatasource );
        ret.append( "\nRemote URL: " + url );
        ret.append( "\n\tSQL Elements:" );
        for ( int j = 0; j < sqlElements.length; j++ )
        {
            ret.append( "\n\t\t" + sqlElements[j].buildValue() );
        }
        ret.append( "\n\tLink Elements:" );
        for ( int j = 0; j < linkElements.length; j++ )
        {
            ret.append( "\n\t\t" + linkElements[j].buildValue() );
        }

        return ret.toString(  );
    }

    /**
     * This method should build a Node object (or object that inherits from Node) for inclusion in the xml
     * representation of the MRALD form. Unless otherwise noted, it is assumed that this will be added to the root
     * node. It is used in buliding the XML file.
     *
     * @param document The Document object the return Node will be added to
     *
     * @return A Node object for inclusion in the Document being built.
     */
    public org.w3c.dom.Node toXml( Document document )
    {
        Element ret = document.createElement( "broadcast_target" );
        ret.setAttribute( "name", name );
        ret.setAttribute( "local_datasource", localDatasource );
        ret.setAttribute( "url", url.toString(  ) );
        ret.setAttribute( "remote_datasource", remoteDatasource );

        return ret;
    }

    /**
     * Get name property.
     *
     * @return Name property.
     */
    public String getName(  )
    {
        return this.name;
    }

    /**
     * Set name property.
     *
     * @param name New name property.
     */
    public void setName( String name )
    {
        this.name = name;
    }

    /**
     * Get localDatasource property.
     *
     * @return LocalDatasource property.
     */
    public String getLocalDatasource(  )
    {
        return this.localDatasource;
    }

    /**
     * Set localDatasource property.
     *
     * @param localDatasource New localDatasource property.
     */
    public void setLocalDatasource( String localDatasource )
    {
        this.localDatasource = localDatasource;
    }

    /**
     * Get remoteDatasource property.
     *
     * @return RemoteDatasource property.
     */
    public String getRemoteDatasource(  )
    {
        return this.remoteDatasource;
    }

    /**
     * Set remoteDatasource property.
     *
     * @param remoteDatasource New remoteDatasource property.
     */
    public void setRemoteDatasource( String remoteDatasource )
    {
        this.remoteDatasource = remoteDatasource;
    }

    /**
     * Get url property.
     *
     * @return Url property.
     */
    public URL getUrl(  )
    {
        return this.url;
    }

    /**
     * Set url property.
     *
     * @param surl New url property.
     *
     * @throws MalformedURLException DOCUMENT ME!
     */
    public void setUrl( String surl ) throws MalformedURLException
    {
        url = new URL( surl );
    }
}

