/*
 *  Copyright 2008 The MITRE Corporation (http://www.mitre.org/). All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.mitre.mrald.taglib;

import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;

import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.TagSupport;

import org.mitre.mrald.util.MetaData;
import org.mitre.mrald.util.MraldConnection;
import org.mitre.mrald.util.MraldMessage;

/**
 *  Description of the Class
 *
 *@author     tcornett
 *@created    September 1, 2004
 */
public class MessageListTag extends TagSupport
{
    /**
     *  Constructor for the AllTablesListTag object
     */
    public MessageListTag() { }


    /**
     *  Description of the Method
     *
     *@return                   Description of the Return Value
     *@exception  JspException  Description of the Exception
     */
    public int doStartTag()
        throws JspException
    {
        try
        {
            StringBuilder ret = new StringBuilder();
            ret.append( "<div class=\"leftSideBar\">" );
            ret.append( "<p class=\"sideBarTitle\">Message List</p>" );
            ret.append( "<form action=\"MessageHandler.jsp\" method=\"POST\" name=\"MessageList\">" );
            ret.append( getButtons() );
            ret.append( "<br />" );
            ret.append( getBody() );
            ret.append( "<br /></form>\n</div>" );
            pageContext.getOut().print( ret.toString() );
            return EVAL_BODY_INCLUDE;
        }
        catch ( IOException e )
        {
            throw new JspException( e );
        }
    }


    /**
     *  Standard entry for the Tag - kinda like main() for stand alone apps
     *
     *@return                   Always 0.
     *@exception  JspException  Standard exception - ones not caught will fall
     *      through to the ErrorPage.jsp
     */
    public int doEndTag()
        throws JspException
    {
        return 0;
    }


    /**
     *  Gets the dropDown attribute of the DropDownListTag object
     *
     *@return                   The dropDown value
     *@exception  JspException  Description of the Exception
     */
    public String getBody()
        throws JspException
    {
        try
        {
            Connection conn = new MraldConnection( MetaData.ADMIN_DB ).getConnection();
            ResultSet rs;
            StringBuilder buffer = new StringBuilder();
            String select = "SELECT DISTINCT * FROM message WHERE status = 'NEW' OR status = 'READ'";
            try
            {
                rs = conn.createStatement().executeQuery( select );
            }
            catch ( SQLException e )
            {
                if ( !MraldConnection.createMessageTable() )
                {
                    throw new JspException( e );
                }
                rs = conn.createStatement().executeQuery( select );
            }

            if ( MraldMessage.getTotalCount() == 0 )
            {
                buffer.append( "<i>No Messages to Display...</i>\n" );
            }
            else
            {
                while ( rs.next() )
                {
                    buffer.append( "<input type='checkbox' name='selectedmessage' value='" + rs.getString( "id" ) + "' />\n" );
                    if ( rs.getString( "status" ).equals( "NEW" ) )
                    {
                        buffer.append( "<font size='-1'><a href='javascript:void(0);' onclick=\"window.open('ViewMessage.jsp?id=" );
                        buffer.append( rs.getString( "id" ) );
                        buffer.append( "', 'Legen', 'width=300,height=300,status=yes,scrollbars=yes,toolbar=no,resizable' );return false;\"><b>" );
                        buffer.append( rs.getString( "title" ) );
                        buffer.append( "</b></a></font>\n<br />" );
                    }
                    else
                    {
                        buffer.append( "<font size='-1'><a href='javascript:void(0);' onclick=\"window.open('ViewMessage.jsp?id=" );
                        buffer.append( rs.getString( "id" ) );
                        buffer.append( "', 'Legen', 'width=300,height=300,status=yes,scrollbars=yes,toolbar=no,resizable' );return false;\">" );
                        buffer.append( rs.getString( "title" ) );
                        buffer.append( "</a></font>\n<br />" );
                    }
                }
            }
            rs.close();
            conn.close();
            return buffer.toString();
        }
        catch ( SQLException e )
        {
            throw new JspException( e );
        }
        catch ( ClassNotFoundException e )
        {
            throw new JspException( e );
        }
    }


    /**
     *  Gets the dropDown attribute of the DropDownListTag object
     *
     *@return                   The dropDown value
     *@exception  JspException  Description of the Exception
     */
    public String getButtons()
        throws JspException
    {
        StringBuilder buffer = new StringBuilder();
        buffer.append( "<script type=\"text/javascript\">\n" );
        buffer.append( "function CheckAll()\n" );
        buffer.append( "{\n" );
        buffer.append( "    var ml = document.MessageList;\n" );
        buffer.append( "    var len = ml.elements.length;\n" );
        buffer.append( "    for (var i = 0; i < len; i++)\n" );
        buffer.append( "    {\n" );
        buffer.append( "        var e = ml.elements[i];\n" );
        buffer.append( "            e.checked = !(e.checked);\n" );
        buffer.append( "    }\n" );
        buffer.append( "}\n" );
        buffer.append( "</script>\n" );
        buffer.append( "<input type='checkbox' name='checkall' onChange='javascript:CheckAll();' />\n" );
        buffer.append( "<input type='submit' name='DeleteMessages' value='Delete' />\n" );
        return buffer.toString();
    }
}

