/*
 *  Copyright 2008 The MITRE Corporation (http://www.mitre.org/). All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.mitre.mrald.util;

import java.util.ArrayList;
import java.util.Properties;

import org.jgraph.JGraph;
import org.jgraph.graph.CellMapper;
import org.jgraph.graph.VertexView;
import org.mitre.lattice.custom.DefaultNode;
import org.mitre.lattice.graph.EllipseCell;
import org.mitre.lattice.graph.EllipseView;
import org.mitre.lattice.lattice.LatticeFunctionsImpl;
import org.mitre.lattice.lattice.LatticeNode;
import org.mitre.lattice.taglib.GroupModifyListTag;
import org.mitre.lattice.util.Constants;
import org.mitre.lattice.util.DefaultConstants;
import org.mitre.lattice.util.ImageUtils;
/**
 * This class willl take care of making the new LatticeNodes that
 * are specific to customizable versions.
 * e.g. For NeuroInformatics, creates NeuroNodes
 *
 *@author     Gail Hamilton, ghamilton@mitre.org, The MITRE Corporation
 *@created    December 15, 2003
 *@see
 *@version    1.0
 */
public class LatticeFactory
{
    public final boolean usingLatticeSecurityModel=true;

	public LatticeFactory()
	{
	}

    public boolean getUsingLatticeSecurityModel()
    {
        return usingLatticeSecurityModel;
    }

   	public LatticeNode createNode(LatticeNode newNode)
	{
		//return new NeuroNode(newNode);
		return new DefaultNode(newNode);
	}

	public LatticeNode createNode( String nodeName, ArrayList<LatticeNode> children, ArrayList<LatticeNode> parents)
	{
	        //return new NeuroNode(nodeName, children, parents);
		return new DefaultNode(nodeName, children, parents);
	}

	public LatticeNode createNode( String nodeName)
	{
		//log.info( "Lattice Factory: Creating a NeuroEllipseNode. String only. No Type " );

		//return new NeuroNode(nodeName);
		return new DefaultNode(nodeName);
	}

	public  LatticeNode createNodeWithoutChildren( LatticeNode newNode)
	{
		//return new NeuroNode(newNode.getName(), new ArrayList(), newNode.getParents());
		return new DefaultNode(newNode.getName(), new ArrayList<LatticeNode>(), newNode.getParents());
	}

	public  LatticeNode copyNode(LatticeNode newNode)
	{
		boolean isCopy = true;
		//return new NeuroNode(newNode, isCopy);

		return new DefaultNode(newNode, isCopy);
	}

	public EllipseCell createCell( LatticeNode newNode )
	{
	//MraldOutFile.logToFile( Config.getProperty("LOGFILE") , "Lattice Factory: Creating a NeuroEllipseCell " );

		//return new NeuroEllipseCell(newNode);
		return new EllipseCell(newNode.getName());
	}

	public  EllipseCell createCell( String name, String type )
	{
	//MraldOutFile.logToFile( Config.getProperty("LOGFILE") , "Lattice Factory: Creating a NeuroEllipseCell " );

		//return new NeuroEllipseCell(name, type);
		return new EllipseCell(name);
	}
	public VertexView createView(Object v, JGraph graph, CellMapper cm)
	{

		return new EllipseView(v,graph,cm);
		//return new NeuroEllipseView(v,graph, cm );
	}

	public LatticeFunctionsImpl getLatticeFunctionImpl()
	{
		// default
		return new LatticeFunctionsImpl();
		//return new NeuroLatticeFunctionsImpl();
	}

	public  GroupModifyListTag getGroupModifyListTag()
	{
		// default
		return new GroupModifyListTag();
		//return new NeuroGroupModifyListTag();
	}

	public Constants getConstants()
	{
		// default\
		//MraldOutFile.logToFile( Config.getProperty("LOGFILE") , "Lattice Factory: Getting  Constants " );

	        return new DefaultConstants();
		//return new NeuroConstants();

	}
	public  Properties getProperties()
	{
		// default
		return DefaultConstants.getProperties();
		///return NeuroConstants.getProperties();
	}

	public String[] getNodeTypes()
	{
		// default
		return DefaultConstants.getNodeTypes();
		//return NeuroConstants.getNodeTypes();
	}

	public  ImageUtils getImageUtils()
	{
		// default
		return new ImageUtils();
		//return new NeuroImageUtils();
	}
}

