/*
 *  Copyright 2008 The MITRE Corporation (http://www.mitre.org/). All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package test.org.mitre.lattice.lattice;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

import org.mitre.lattice.graph.SampleLattices;
import org.mitre.lattice.lattice.LatticeNode;
import org.mitre.lattice.lattice.LatticeTree;
import org.mitre.lattice.lattice.LatticeUserGroup;
import org.mitre.lattice.lattice.NodeNotFoundException;
import org.mitre.mrald.util.Config;

/**
 *  Description of the Class
 *
 *@author     ghamilton
 *@created    Dec 1, 2003
 */
public class GraphUserLatticeTest extends TestCase
{

    private LatticeTree tree = null;
//    private LatticeUserGroup userGroup = null;

    /**
     *  The main program for the LatticeNodeTest class
     *
     *@param  args  The command line arguments
     */
    public static void main( String[] args )
    {
        junit.textui.TestRunner.run( suite() );
    }


    /**
     *  A unit test suite for JUnit
     *
     *@return    The test suite
     */
    public static Test suite()
    {
        /*
         *  the dynamic way
         */
        return new TestSuite( GraphUserLatticeTest.class );
    }



    /**
     *  Description of the Method
     */
    public void resetNodes()
    {
        setUp();
    }


    /**
     *  The JUnit setup method
     */
    protected void setUp()
    {
        Config.setProperty( "LOGFILE", "neuro.log" );
        Config.setProperty( "LOGPATH", System.getProperty( "antfile.dir" ) );
        Config.setProperty( "mraldLogLevel", "2" );
        Config.setLatticeFactory( new org.mitre.mrald.util.LatticeFactory() );
        tree = SampleLattices.buildVeryVeryComplexDiamondLattice();
        /*
         *  userGroup =
         */
            new LatticeUserGroup( "gail" );
    }


    /**
     *  The JUnit teardown method
     */
    protected void tearDown()
    {
    }


    /**
     *  A unit test for JUnit
     */
    public void testDeleteLink()
    {
        int countChild = 0;
        int countParent = 0;
        //Set up name of links to be deleted
        String deleteParent = "midLeftPoint";
        String deleteChild = "leftPoint";
        LatticeNode node = null;
        LatticeNode child = null;

        try
        {
            node = tree.searchTree( deleteParent );
        }
        catch ( NodeNotFoundException e )
        {
            fail( "Could not find node " + deleteParent );
        }
        //assertNotEquals( "Parent Node is not null ", null, deleteParent);

        try
        {
            child = tree.searchTree( deleteChild );
        }
        catch ( NodeNotFoundException e )
        {
            fail( "Could not find node " + deleteChild );
        }//assertNotEquals( "Child Node is not null ", null, deleteChild);

        countParent = child.getParents().size();
        assertEquals( "Before removal the number of parent nodes is  ", countParent, child.getParents().size() );
        child.getParents().remove( node );
        assertEquals( "After removal the number of parent nodes is  ", countParent - 1, child.getParents().size() );

        countChild = node.getChildren().size();
        assertEquals( "Before removal the number of child nodes is  ", countChild, node.getChildren().size() );
        node.getChildren().remove( child );
        assertEquals( "After removal the number of child nodes is  ", countChild - 1, node.getChildren().size() );

    }

}


