/*
 *  Copyright 2008 The MITRE Corporation (http://www.mitre.org/). All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */




package test.org.mitre.mrald.output;

import java.io.ByteArrayInputStream;
import java.util.List;
import junit.framework.*;
import org.mitre.mrald.query.*;
import org.xml.sax.helpers.XMLReaderFactory;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

public class BroadcastQueryTargetsParserTest extends TestCase
{

    String XML = "<remote_targets>" +
        "<broadcast_target name=\"Local Admin\" local_datasource=\"db_admin.props\" url=\"http://127.0.0.1:8080/mrald\" remote_datasource=\"db_admin.props\" />" +
        "<broadcast_target name=\"Local Baseball\" local_datasource=\"db_baseball.props\" url=\"http://127.0.0.1:8080/mrald\" remote_datasource=\"db_baseball.props\" />" +
        "</remote_targets>";
    List <BroadcastQueryTarget> targets;

    /*
     * add tests here
     */
     public void testParser()
     {
         boolean OK = false;
         for( BroadcastQueryTarget target : targets )
         {
             if( target.getName().equals("Local Admin" ))
             {
                 assertEquals(target.getLocalDatasource(), "db_admin.props");
                 assertEquals(target.getUrl().toString(), "http://127.0.0.1:8080/mrald");
                 assertEquals(target.getRemoteDatasource(), "db_admin.props");
                 OK = true;
             }
         }
         assertTrue("Local Admin broadcast target not found", OK);
     }

    /**
     *  The JUnit setup method
     */
    protected void setUp() throws Exception
    {
        //create input stream to xml source document
        byte[] xmlBytes = XML.getBytes();
        ByteArrayInputStream in_stream = new ByteArrayInputStream(xmlBytes);

        // Create SAX 2 parser...
        XMLReader xr = XMLReaderFactory.createXMLReader();
        // Set the ContentHandler...
        BroadcastQueryTargetsParser parser = new BroadcastQueryTargetsParser();
        xr.setContentHandler(parser);
        // Parse the file...
        xr.parse(new InputSource(in_stream));
        in_stream.close();
        targets = parser.getBroadcastQueryTargets();
    }

    /**
     *  The JUnit teardown method
     */
    protected void tearDown()
    {
    }


    public static void main( String[] args )
    {
        junit.textui.TestRunner.run( suite() );
    }


    /**
     *  A unit test suite for JUnit
     *
     *@return    The test suite
     */
    public static Test suite()
    {
        /*
         *  the dynamic way
         */
        return new TestSuite( BroadcastQueryTargetsParserTest.class );
    }
}


