/*
 *  Copyright 2008 The MITRE Corporation (http://www.mitre.org/). All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package test.org.mitre.mrald.util;

import java.io.*;
import java.util.*;
import junit.framework.*;
import org.mitre.mrald.util.*;
import org.mitre.mrald.parser.ParserElement;
import org.mitre.mrald.query.*;


public class SimpleTargetProviderTest extends TestCase
{
    public final String XML = "<remote_targets>" +
        "<broadcast_target name=\"Local Admin\" local_datasource=\"db_admin.props\" url=\"http://127.0.0.1:8080/mrald\" remote_datasource=\"db_admin.props\" />" +
        "<broadcast_target name=\"Local Baseball\" local_datasource=\"db_baseball.props\" url=\"http://127.0.0.1:8080/mrald\" remote_datasource=\"db_baseball.props\" />" +
        "</remote_targets>";
    SimpleTargetProvider provider;
    /*
     * add tests here
     */
    public void testGetTargets()
    {
        List<BroadcastQueryTarget> targets = provider.getTargets( new ArrayList<ParserElement>(), new ArrayList<LinkElement>(), "db_admin.props");
        assertEquals( "Size of resulting list was incorrect.", targets.size(), 1);
        assertEquals( targets.get(0).getName(), "Local Admin");
        targets = provider.getTargets( new ArrayList<ParserElement>(), new ArrayList<LinkElement>(), "db_baseball.props");
        assertEquals( "Size of resulting list was incorrect.", targets.size(), 1);
        assertEquals( targets.get(0).getName(), "Local Baseball");
    }

    /**
     *  The JUnit setup method
     */
    protected void setUp()
    {
        //create input stream to xml source document
        byte[] xmlBytes = XML.getBytes();
        ByteArrayInputStream in = new ByteArrayInputStream(xmlBytes);
        provider = new SimpleTargetProvider(false);
        provider.reload(in);
        /*
         *  set up Config
         */
        Config.setProperty( "MAILTO", "jchoyt@mitre.org" );
        Config.setProperty( "SMTPHOST", "localhost" );
    }

    /**
     *  The JUnit teardown method
     */
    protected void tearDown()
    {
    }


    public static void main( String[] args )
    {
        junit.textui.TestRunner.run( suite() );
    }


    /**
     *  A unit test suite for JUnit
     *
     *@return    The test suite
     */
    public static Test suite()
    {
        /*
         *  the dynamic way
         */
        return new TestSuite( SimpleTargetProviderTest.class );
    }
}


