/*
 *  Copyright 2008 The MITRE Corporation (http://www.mitre.org/). All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.mitre.lattice.neuro.taglib;

import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Logger;

import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.TagSupport;

import org.mitre.lattice.query.LatticeQuery;
import org.mitre.mrald.util.Config;
import org.mitre.mrald.util.MiscUtils;
import org.mitre.mrald.util.MraldConnection;
import org.mitre.mrald.util.MraldException;
import org.mitre.mrald.util.User;

/**
 *  Description of the Class
 *
 *@author     ksarver
 *@created    Sept 16, 2003
 */
public abstract class NeuroSpecificTag extends TagSupport
{

    public final static String KEY = NeuroSpecificTag.class.getName();
    public final static Logger log = Logger.getLogger( KEY );
    //log.setLevel(Level.FINEST);
	protected int processCount = 0;

	protected final static String  DATASOURCE = "main";
	/**
	 *  Constructor for the SubjectBoxTag object
	 */
	public NeuroSpecificTag()
	{
		super();
	}


	/**
	 *  Retrieves and prints the user's personal forms list
	 *
	 *@return                   An int. Not used for anything.
	 *@exception  JspException  Required by TagSupport. Used ot pass up the other
	 *      exceptions.
	 */
	public int doStartTag()
		 throws JspException
	{
		try
		{
			User user = (User) pageContext.getSession().getAttribute(Config.getProperty("cookietag"));

			StringBuffer ret = new StringBuffer(init());

			ret.append(processQuery(getQuery(), user));

			/*String[] queries = getQuery();
			for (int i=0; i < queries.length; i++)
			{
				MraldOutFile.logToFile(Config.getProperty("LOGFILE"), "NeuroSpecificTag: doStartTag:  " + queries[i] );

				//queries[i]= MiscUtils.checkApostrophe(queries[i]);
			}
			ret.append(processQuery(queries,user));*/
			ret.append(endOutput());

			pageContext.getOut().print(ret.toString());

		} catch (IOException e)
		{
			throw new JspException(e.getMessage());
		} catch (Exception e)
		{
			throw new JspException(e.getMessage());
		}
		return 0;
	}


	/**
	 *  Description of the Method
	 *
	 *@return    Description of the Return Value
	 */
	protected String init()
	{
		return null;
	}


	/**
	 *  Gets the query attribute of the NeuroSpecificTag object
	 *
	 *@return    The query value
	 */
	protected abstract String[] getQuery();


	/**
	 *  Description of the Method
	 *
	 *@param  query               Description of the Parameter
	 *@param  user                Description of the Parameter
	 *@return                     Description of the Return Value
	 *@exception  MraldException  Description of the Exception
	 */
	public String processQuery(String[] query, User user) throws MraldException
	{
		try
		{
			StringBuffer ret = new StringBuffer();

			MraldConnection conn = new MraldConnection(DATASOURCE);
			Connection con = conn.getConnection();
//			LatticeQuery latQuery = new LatticeQuery();

			ResultSet rs =null;
			for (int i=0; i < query.length; i++)
			{
			    String queryFinal = LatticeQuery.adaptQuery(query[i], user);


			    StringBuffer logInfo = new StringBuffer();

			    long startTime = MiscUtils.logQuery(user.getEmail(), DATASOURCE, query[i], logInfo);


			   // MraldOutFile.appendToFile( "In NeuroSpecificTag, executing: "+queryFinal );
			    Statement stmt = con.createStatement(
                        ResultSet.TYPE_SCROLL_INSENSITIVE,
                        ResultSet.CONCUR_UPDATABLE);

			    rs = stmt.executeQuery(queryFinal);
			    /*
			     *  RETURN success status
			    */
			    MiscUtils.logQueryRun(startTime, logInfo);

			    processCount = i + 1;
			    ret.append(processResultSet(rs));
			}
			rs.close();
			conn.close();
			return ret.toString();
		} catch (SQLException e)
		{
			throw new MraldException(e);
		}
	}


	/**
	 *  Description of the Method
	 *
	 *@param  rs                Description of the Parameter
	 *@return                   Description of the Return Value
	 *@exception  SQLException  Description of the Exception
	 */
	protected abstract String processResultSet(ResultSet rs) throws MraldException;

	/**
	 *  To finish off all the <table> tags at the end of the page
	 *
	 *@param  rs                Description of the Parameter
	 *@return                   Description of the Return Value
	 *@exception  SQLException  Description of the Exception
	 */

	protected abstract String endOutput();

}

