/*
 *  Copyright 2008 The MITRE Corporation (http://www.mitre.org/). All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.mitre.lattice.neuro.taglib;
import ij.ImagePlus;
import ij.io.FileInfo;
import ij.io.FileOpener;
import ij.plugin.JpegWrapper;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;

import org.mitre.mrald.util.Config;
import org.mitre.mrald.util.MiscUtils;
import org.mitre.mrald.util.MraldException;
import org.mitre.mrald.util.MraldOutFile;
import org.mitre.neuro.util.EndianCorrectedChannel;
/**
 *  Description of the Class
 *
 *@author     ghamilton
 *@created    April 20, 2004
 */
public class VolumeDetailTag extends NeuroSpecificTag
{
	/**
	 *  Constructor for the VolumeDetailTag object
	 */
	public VolumeDetailTag()
	{
		super();
		MraldOutFile.logToFile( "VolumeDetailTag : Start"  );

	}


	/**
	 *  Gets the query attribute of the MedicalTestResultTag object
	 *
	 *@return    The query value
	 */
	protected String[] getQuery()
	{

		String volumeID = pageContext.getRequest().getParameter("volume_id");
		volumeID =  MiscUtils.checkApostrophe(volumeID);

		String query = "SELECT volume.volume_id, volume.scan_id, modality, file_format, numerical_format, state, endianness, xdimension, ydimension, zdimension, " +
			" xfov, yfov, zfov, xorientation, yorientation, zorientation ,xresolution, yresolution, zresolution , filename " +
			" FROM volume LEFT OUTER JOIN images ON (volume.volume_id= images.volume_id) " +
			" WHERE volume.volume_id = '" + volumeID + "'" ;;

		String query2 = "SELECT  subject.subject_id " +
			" FROM subject, scan_event, volume " +
			" WHERE volume.volume_id = '" + volumeID + "'" +
			" AND scan_event.subject_id = subject.subject_id " +
			" AND volume.scan_id = scan_event.scan_id ";

		return new String[]{query, query2};
	}


	/**
	 *  Description of the Method
	 *
	 *@return    Description of the Return Value
	 */
	protected String init()
	{
		StringBuffer ret = new StringBuffer();
		ret.append("<table width=\"100%\" border=\"0\" cellspacing=\"1\" cellpadding=\"2\">");
		ret.append("<tr><th colspan= \"2\" style=\"letter-spacing:0.3em\">Volume Details</th></tr>");

		return ret.toString();
	}


	/**
	 *  Description of the Method
	 *
	 *@return    Description of the Return Value
	 */
	protected String endOutput()
	{
		return "</table>";
	}


	/**
	 *  Description of the Method
	 *
	 *@param  rs                  Description of the Parameter
	 *@return                     Description of the Return Value
	 *@exception  MraldException  Description of the Exception
	 */
	protected String processResultSet(ResultSet rs) throws MraldException
	{
		try
		{

			String subjID = pageContext.getRequest().getParameter("subject_id");

			String retAll = null;
			StringBuffer ret = new StringBuffer();
			StringBuffer retStart = new StringBuffer();
			int noOfVolume = 0;


			if (processCount == 1)
			{
				ResultSetMetaData rsmd = rs.getMetaData();
				int numberOfColumns = rsmd.getColumnCount();

				int rowNo = 0;
				while (rs.next())
				{

					for (int i = 0; i < (numberOfColumns - 1); i++)
					{

						ret.append("<tr>");
						ret.append("<td width=\"50%\" align=\"right\"><b>" +
                            rsmd.getColumnLabel(i + 1) + ": </b></td>");
						ret.append("<td align=\"left\">" + rs.getString(i + 1) + "</td>");
						ret.append("</tr>");
					}
					noOfVolume++;

					rowNo++;
					ret.append("<tr>");
					String fileName = rs.getString("filename");

					int xdim = rs.getInt("xdimension");
					int ydim = rs.getInt("ydimension");
					int zdim = rs.getInt("zdimension");

					ret.append("<td align=\"right\"><b>View Image</b></td><td width=\"50%\" Align=Left><a href=\"viewImage.jsp?imageFile=" +
                        fileName + "\">" + fileName + "</td></tr>");
					ret.append("</tr>");

					ret.append("<tr></tr>");
					ret.append("<tr><td></td><td><form action=\"ImageServer.jsp\"><input type=\"hidden\" name=\"fileName\" value=\"" +
                         fileName + "\"></input><input name=\"fileAction\" type=\"submit\" value=\"download\"></form><br></td></tr>");

					ret.append("<tr><td></td><td><img src=\"");
					String imgName = createSampleSlice(Config.getProperty( "imagesDir" ) + Config.FILE_SEPARATOR + fileName, xdim, ydim, zdim);
					ret.append(imgName + "\"/></td></tr>");
				}

				retStart.append("<tr>");
                retStart.append("<td width=\"50%\" align=\"center\" colspan=\"2\"><b>There are " +
                    noOfVolume + " volume(s) associated with this Subject</b></td>");
                retStart.append("</tr>");
				retAll = retStart.toString() + ret.toString();
			} else
			{
				String subj="";
				while (rs.next())
				{
					ret.append("<tr>");

					if (subjID == null)
					{
						subjID = rs.getString(1);
					}
					subj = subjID;
					if (subjID != null)
						subj = URLEncoder.encode(subjID, "UTF-8");


					ret.append("<td align=\"Right\"><b>Subject Detail</b></td><td width=\"50%\" align=\"left\"><a href=\"subject_info.jsp?subject_id=" + subj + "\">" + subjID + "</td>");
					ret.append("</tr>");
				}

				retAll = ret.toString();

			}



			return retAll;
		} catch (SQLException e)
		{
			throw new MraldException(e.getMessage());
		}
		catch (java.io.UnsupportedEncodingException e)
		{
			throw new MraldException(e.getMessage());
		}
	}

	private String createSampleSlice(String imageName, int xdim, int ydim, int zdim) throws MraldException
	{

		try
		{
			File sourceImage = new File(imageName);
			String destination = MiscUtils.replaceSuffix(sourceImage.toString(), ".jpg");
			String pathDir = Config.getProperty("BasePath");
			pathDir = pathDir.replaceAll(Config.FILE_SEPARATOR + Config.FILE_SEPARATOR, Config.FILE_SEPARATOR);

			String imageFileName = destination.replaceAll(pathDir, "");

			if (new File(destination).exists())
			{
				return imageFileName;
			}
			FileInfo fi = new FileInfo();
			fi.fileName = sourceImage.getName();
			fi.directory = sourceImage.getParent();
			fi.fileFormat = FileInfo.RAW;
			fi.fileType = FileInfo.GRAY16_UNSIGNED;


			fi.width = xdim;
			fi.height = ydim;
			fi.nImages = zdim;
			fi.offset = 0;
			fi.gapBetweenImages = 0;
			fi.intelByteOrder = false;
			fi.whiteIsZero = false;
			ImagePlus result = new FileOpener(fi).open(false);

			result.setSlice(fi.nImages / 2);

			//(new FileSaver(result)).saveAsJpeg(destination);

			(new JpegWrapper()).save(result, destination);
			//MraldOutFile.logToFile( "VolumeDetailTag : createSampleSlice: destination " + destination  );

			//MraldOutFile.logToFile( "VolumeDetailTag : createSampleSlice " + imageFileName  );

			return imageFileName;
		}
		catch(Exception e)
		{
			throw new MraldException(e);
		}
	}
	/**
	 *  Use IJ Classes to generate a mid plane slice of the volume
	 *
	 *@param  rs                  Description of the Parameter
	 *@return                     Description of the Return Value
	 *@exception  MraldException  Description of the Exception
	 */
	protected String getImage(String imageName, int xdim, int ydim, int zdim) throws MraldException
	{
		String tempFile = null;
		try
		{

			File sourceImage = new File(imageName);

			FileInputStream rawData = new FileInputStream(sourceImage);

			tempFile = generateFileName();

			File targetFile = new File(tempFile);

			createFile(rawData.getChannel(), targetFile, xdim, ydim, zdim);

			rawData.close();
		}
		catch (Exception e)
		{
			throw new MraldException(e);
		}
		return tempFile;

	}

	private String generateFileName()
	{
		String tempFile = Config.getProperty( "imagesDir" ) + Config.FILE_SEPARATOR + "temp_img.img";
		return tempFile;
	}
	/**
	 * Copies data from source into the target file; the input stream must not
	 * be closed between invocations of this method because this would reset the
	 * stream.
	 * @param source An input stream (that may have been partially 'consumed'.
	 * @param targetFile The file into which data should be copied.
	 * @throws IOException
	 */
	private void createFile(FileChannel source, File targetFile, int xdim, int ydim, int zdim)
			throws IOException {
		FileChannel target = new FileOutputStream(targetFile).getChannel();

		int imageSize = xdim * ydim * 2;

		int zPos =  zdim % 2;

		if (zPos == 0) zPos = zdim /2;
		else
			zPos = (zdim + 1) / 2;

		int startPosition = xdim * ydim * (zdim / 2);
		//Start the source position at the middle Image
		source.position( imageSize * zPos);
		ByteBuffer buffer = ByteBuffer.allocate(imageSize);
		source.read(buffer);
		buffer.position(0);
		target.write(buffer);
		target.close();
	}

}

