/*
 *  Copyright 2008 The MITRE Corporation (http://www.mitre.org/). All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.mitre.neuroWeb;

import org.mitre.mrald.query.*;

import org.mitre.mrald.util.*;
import java.io.*;
import java.util.*;
import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.util.Date;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import org.mitre.mrald.util.Config;
import org.mitre.mrald.util.JdbcTemplates;
import org.mitre.mrald.util.MetaData;
import org.mitre.mrald.util.MraldOutFile;
import org.mitre.mrald.util.OtherDbPropsSubscriber;

/**
 *  This allows for initial neuroweb setup..mainly here to reset the value of the ADMIN_DB
 *
 *
 *@author     Jeffreh Hoyt
 *@version    1.0
 */

public class InitServlet extends org.mitre.mrald.servlets.InitServlet
{

    /**
     *  Description of the Method
     *
     *@param  config                Description of the Parameter
     *@exception  ServletException  Description of the Exception
     */
    public void init( ServletConfig config )
        throws ServletException
    {
        /*
         *  required for all Servlets
         */
        super.init( config );
        System.out.println( "IN NEUROWEB INITSERVLET" );
        MetaData.ADMIN_DB = "main";
    }

    /**
     *  Description of the Method
     *
     *@param  req                   Description of the Parameter
     *@param  resp                  Description of the Parameter
     *@exception  ServletException  Description of the Exception
     *@exception  IOException       Description of the Exception
     */
    public void doGet( HttpServletRequest req, HttpServletResponse resp )
        throws IOException, ServletException
    {
        doPost( req, resp );
    }


    /**
     *  Description of the Method
     *
     *@param  req                   Description of the Parameter
     *@param  resp                  Description of the Parameter
     *@exception  ServletException  Description of the Exception
     *@exception  IOException       Description of the Exception
     */
    public void doPost( HttpServletRequest req, HttpServletResponse resp )
        throws IOException, ServletException
    {
        super.doPost( req, resp );
    }


    public static final String HSQLDB_PREFIX = "jdbc:hsqldb:file:";
}

