/*
 *  Copyright 2008 The MITRE Corporation (http://www.mitre.org/). All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.mitre.neuroWeb;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

import org.jfree.data.category.CategoryDataset;
import org.jfree.data.xy.CategoryTableXYDataset;
import org.mitre.mrald.util.MraldConnection;

import de.laures.cewolf.DatasetProducer;
import de.laures.cewolf.links.CategoryItemLinkGenerator;
import de.laures.cewolf.links.LinkGenerator;
import de.laures.cewolf.tooltips.CategoryToolTipGenerator;
import de.laures.cewolf.tooltips.ToolTipGenerator;
/**
 *  Description of the Class
 *
 *@author     ghamilton
 *@created    Nov 7th, 2007
 */
public class ScatterDatasetProducer implements DatasetProducer , CategoryToolTipGenerator, CategoryItemLinkGenerator
{

			ArrayList<String> imageNames = new ArrayList<String>();
			String[] imageSet = null;
			Map dummy = new HashMap();
			java.util.Date dummyDate = new java.util.Date();
			String[] queries = new String[]{};
			int version=0;
			String query="";

			public ScatterDatasetProducer(String[] sqlQueries, int newVersion)
			{
				queries = sqlQueries;
				version = newVersion;
				query=queries[version];
			}

			public Object produceDataset(java.util.Map params)
			{

			    CategoryTableXYDataset ds = new CategoryTableXYDataset();

			    try
			    {
				MraldConnection mconn = new MraldConnection();
				ResultSet rs = mconn.executeQuery(query);
				  int count = 0;
				while(rs.next())
				{
					count++;

				   String val1 = rs.getString(2);
				   if (val1== null)
				   {
				   	val1 = "Unknown";
				   }

				   float val2 = rs.getFloat(1);
				   //Do not plot zero
				   if (val2 !=0)
				   	ds.add(count,val2,val1);
				  imageNames.add(val1);

				}

				 setUpImageSet();
			    }
			    catch(Exception e)
			    {
				throw new RuntimeException(e);
			    }
			    return ds;
			}

			private void setUpImageSet()
			{
				int noOfImages = imageNames.size();
				imageSet = new String[noOfImages];
				for (int i=0; i < noOfImages; i++)
				{
					imageSet[i] = imageNames.get(i);
				}
			}

			public String getProducerId()
			{
			     return "scatterChartData";
			}

			public boolean hasExpired(java.util.Map params, java.util.Date since)
			{
			    return true;
			}

			 LinkGenerator scatterLG = new CategoryItemLinkGenerator()
			    {
				public String generateLink(Object dataset, int test, Object category)
				{
				    StringBuffer ret = new StringBuffer( "" );
				    ret.append( "#" + category );
				    return ret.toString();
				}
			    };

			    public LinkGenerator getScatterLG()
				   {
				   	return scatterLG;
				   }

			    ToolTipGenerator scatterTP = new CategoryToolTipGenerator()
			    {
				     public String generateToolTip(CategoryDataset arg0, int series, int arg2)
				     {
					return imageSet[series];
				     }

			     };

			     public ToolTipGenerator getScatterTP()
				   {
				   	return scatterTP;
				   }

				public String generateToolTip(CategoryDataset arg0, int series,
						int arg2) {
					// TODO Auto-generated method stub
					return imageSet[series];
				}

				public String generateLink(Object arg0, int arg1, Object arg2) {
					// TODO Auto-generated method stub
					StringBuffer ret = new StringBuffer( "" );
				    ret.append( "#" + arg1 );
				    return ret.toString();
				}

		}