/*
 *  Copyright 2008 The MITRE Corporation (http://www.mitre.org/). All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.mitre.neuroWeb;

import java.sql.*;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.SQLException;
import org.mitre.mrald.output.HTMLOutput;

import javax.servlet.http.HttpSession;

import org.mitre.mrald.util.Config;
import org.mitre.mrald.util.MraldException;
import org.mitre.mrald.util.MraldOutFile;
import org.mitre.mrald.util.User;
import org.mitre.neuroWeb.taglib.SubjectVolumeListTag;

import java.io.FileReader;
import java.io.BufferedReader;
import java.io.File;
/**
 *  This HTMLOutput Class specializes the OutputManager class. It specifically
 *  gathers information pertaining to the output columns desired by the user. As
 *  the query is constructed, this class adds output information and updates the
 *  columns and joins necessary to obtain this output information
 *
 *@author     Gail Hamilton
 *@created    February 2, 2001
 *@version    1.0
 */

public class SummaryOutput extends HTMLOutput
{

    /**
     *  Description of the Field
     */
    public final static String KEY = SummaryOutput.class.getName();
    /**
     *  Description of the Field
     */
    public final static Logger log = Logger.getLogger( KEY );

    public int count = 0;//This must be set before printCount() is called.

    private User mraldUser = null;

    static
    {
        log.setLevel( Level.FINER );
    }


    /**
     *  Constructor for the HTMLOutput object
     *
     *@since
     */
    public SummaryOutput()
    {

        super();
        //MraldOutFile.logToFile(Config.getProperty("LOGFILE"), "SummaryOutput. Constructor"  );

    }

    public @Override void printStart()
    throws IOException
    {
    	HttpSession session = msg.getReq().getSession();

    	if (session != null)
    		mraldUser = (User)session.getAttribute(Config.getProperty( "cookietag" ));
        //****Setting Servlet Output variables
        //PrintWriter out = msg.getOutPrintWriter();

        out.println( "<html><head>" );
        out.println( "<script type=\"text/javascript\" src=\"checkboxToggle.js\"></script>" );
        out.println( "\n<!--" + dbQuery + " -->\n" );

        writeFile( new File( Config.getProperty( "BasePath" ), "title.html" ), out );

        out.println("</head><body onload='addCount()'><div id=\"wrap\">");
        out.println("<form enctype=\"x-www-form-urlencoded\" action=\"addToCart.jsp\" name=\"o\" method=\"POST\" >");

         writeFile( new File( Config.getProperty( "BasePath" ), "header.html" ), out );
         out.println("<div id=\"content\"><h2>Subject <strong><span class=\"blue\"></span><span class=\"gray\">List </span></strong></h2><p>");
        out.println( "<br/><a onclick=\"CheckAll('cart');\">Select All</a>/<a onclick=\"ClearAll('cart');\">Unselect All</a><center><table width=\"80%\" border='0' cellpadding='3'>" );


    }

    public @Override void printEnd()
    {
    	out.println( "</table></center><p><br/><a onclick=\"CheckAll('cart');\">Select All</a>/<a onclick=\"ClearAll('cart');\">Unselect All</a>" );
        out.println( "</p><center><input type=\"submit\" value=\"Add Selected Images to Cart\"/> </center></form>" );
		out.println("</p></div>");

         writeFile( new File( Config.getProperty( "BasePath" ), "menus.html" ), out );

        out.println( "</body></html>" );
    }

    public @Override void printBody( )
        throws IOException, SQLException
    {
    	boolean newline = false;
           // int count = 0;
        ResultSetMetaData rsmd = rs.getMetaData();

        int numberOfColumns = rsmd.getColumnCount();

        String style_normal="background:#4088b8;color:#c8c8c8;";


        while (rs.next())
        {
   			String fileName = rs.getString("filename");
   			String volumeId = rs.getString("volume_id");
   			String subjID = rs.getString("subject_id");
            String preveiwFile = Config.getProperty("BaseUrl") +
                Config.FILE_SEPARATOR + "data" +
                Config.FILE_SEPARATOR + fileName;
            preveiwFile = preveiwFile.substring( 0, preveiwFile.length() - 8 ) + "_preview3.png";

   			int xdim = rs.getInt("xdimension");
   			int ydim = rs.getInt("ydimension");
   			int zdim = rs.getInt("zdimension");

   			out.print("<table>");

   			for ( int i = 0; i < niceNames.length; i++ )
   	        {

   				if (rsmd.getColumnLabel(i + 1).equals("numerical_format") ||
                    rsmd.getColumnLabel(i + 1).contains("resolution"))
   					continue;

   				out.print("\n<tr>");
   				out.print("<td width='20%' align='Right'>" + niceNames[i] + ": </td>");
               System.out.println( rsmd.getColumnLabel(i + 1) );
               if (rsmd.getColumnLabel(i + 1).contains("dimension"))
               {
                    out.print("<td align=left><b>" + rs.getString(i + 1) +
                        " (" + rs.getString( rsmd.getColumnLabel(i + 1).substring( 0,1 ) + "resolution" ) +
                        " mm)" + "</b></td>");
               }
               else if (rsmd.getColumnLabel(i + 1).equals("subject_id"))
               {
                   out.print("<td align=left><a style=\"text-decoration:underline\" href=\"subject_info.jsp?subject_id=" + rs.getString(i + 1) + "\"><b>" + rs.getString(i + 1) + "</b></a></td>");
               }
               else
               {
                    out.print("<td align=left><b>" + rs.getString(i + 1) + "</b></td>");
               }
               if( i==0 )
               {
                   out.print( "<td rowspan=\"" + niceNames.length + "\"><img src=\"" + preveiwFile +
                       "\"/><br/><input type=\"checkbox\" name=\"cart\" value=\"" + fileName + "\"/> Add this to my cart</td>");
               }
   				out.print("</tr>");
   				out.print("<tr></tr>");
   			}

   			out.print("<tr><th colspan=\"4\"></th></tr>");
   			out.print("</table>");


   		}
           // ENDWHILE
    }


    /**
     *  Description of the Method
     */
    public void printCount(PrintWriter out)
    {
        out.println( "<script type=\"text/javascript\">" );
        out.println( "function addCount()" );
        out.println( "{" );
        out.println( "var ldiv = document.getElementById(\"count\");" );
        if( count==1 )
        {
            out.println( "var textout = '1 subject found:';" );
        }
        else
            out.println( "var textout = '" + count + " subjects found';" );
        out.println( "ldiv.innerHTML = textout;" );
        out.println( "}" );
        out.println( "</script>" );
    }
    /**
     *  Description of the Method
     *
     *@param  inputFile  Description of the Parameter
     *@param  out        Description of the Parameter
     */
    public void writeFile( File inputFile, PrintWriter out )
    {
        log.entering( KEY, "writeFile", inputFile );
        try
        {
            BufferedReader br = new BufferedReader( new FileReader( inputFile ) );
            String line;
            while ( ( line = br.readLine() ) != null )
            {
                out.print( line );
            }
            br.close();
        }
        catch ( IOException e )
        {
            throw new RuntimeException( e );
        }
        log.exiting( KEY, "writeFile" );
    }

    public @Override void printLimit( ) {}

}
