/*
 *  Copyright 2008 The MITRE Corporation (http://www.mitre.org/). All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.mitre.neuroWeb.taglib;

import java.net.URLEncoder;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;

import org.mitre.lattice.neuro.taglib.NeuroSpecificTag;
import org.mitre.mrald.util.Config;
import org.mitre.mrald.util.MiscUtils;
import org.mitre.mrald.util.MraldException;
import org.mitre.mrald.util.User;
/**
 *  Description of the Class
 *
 *@author     ghamilton
 *@created    April 20, 2004
 */
public class ImageDetailTag extends NeuroSpecificTag
{
	/**
	 *  Constructor for the VolumeDetailTag object
	 */
	public ImageDetailTag()
	{
		super();
	}


	/**
	 *  Gets the query attribute of the MedicalTestResultTag object
	 *
	 *@return    The query value
	 */
	protected String[] getQuery()
	{

		String volumeID = pageContext.getRequest().getParameter("volume_id");
		volumeID =  MiscUtils.checkApostrophe(volumeID);

		String query = "SELECT filename, xdimension, ydimension, zdimension, numerical_format, volume.volume_id, endianness  " +
			//" FROM volume LEFT OUTER JOIN images ON (volume.volume_id= images.volume_id) " +
		" FROM volume, images " +
		" WHERE volume.volume_id = images.volume_id and volume.volume_id = '" + volumeID + "'" ;

		return new String[]{query};
	}


	/**
	 *  Description of the Method
	 *
	 *@return    Description of the Return Value
	 */
	protected String init()
	{
		StringBuffer ret = new StringBuffer();
		ret.append("<table width=\"100%\" border=\"0\" cellspacing=\"1\" cellpadding=\"2\">");
		ret.append("<tr><th colspan=\"2\" style=\"letter-spacing:0.3em\">Image Details</th></tr>");

		return ret.toString();
	}


	/**
	 *  Description of the Method
	 *
	 *@return    Description of the Return Value
	 */
	protected String endOutput()
	{
		return "</table>";
	}


	/**
	 *  Description of the Method
	 *
	 *@param  rs                  Description of the Parameter
	 *@return                     Description of the Return Value
	 *@exception  MraldException  Description of the Exception
	 */
	protected String processResultSet(ResultSet rs) throws MraldException
	{
		try
		{
			User mraldUser = (User)pageContext.getSession().getAttribute(Config.getProperty("cookietag"));

			String retAll = null;
			StringBuffer ret = new StringBuffer();
			StringBuffer retStart = new StringBuffer();
			String style_normal="background:#4088b8;color:#c8c8c8;";

			int noOfImages = 0;

			while (rs.next())
			{

				noOfImages++;

				ret.append("<tr>");
				String fileName = rs.getString("filename");

				ret.append("<td align=\"right\"><b>View Image</b></td><td width=\"50%\" Align=Left><a href=\"viewImage.jsp?imageFile=" +
                        fileName + "\">" + fileName + "</td></tr>");
				ret.append("</tr>");

				ret.append("<tr></tr>");


				int xdim = rs.getInt("xdimension");
				int ydim = rs.getInt("ydimension");
				int zdim = rs.getInt("zdimension");

				String endian = rs.getString("endianness");
				boolean littleEndianness = true;

				if (endian == null)
					littleEndianness = true;
				else
				{
					if (endian.toLowerCase().equals("little"))
						littleEndianness = true;
					else
						littleEndianness = false;
				}
				String numericalFormat = rs.getString("numerical_format");

				//String[] imgNames = SubjectVolumeListTag.createSampleSlice(Config.getProperty( "imagesDir" ) + Config.FILE_SEPARATOR + fileName, xdim, ydim, zdim, numericalFormat,littleEndianness);


				boolean firstTime = true;
/* 				if (imgNames != null)
				{
					for (String imagName: imgNames)
					{
						if (firstTime)
						{
							ret.append("<tr><td colspan=\"4\"><table><tr><td align=\"left\"><img src=\"");
							firstTime = false;
						}
						else
							ret.append("<td><img src=\"");

						ret.append(imagName + "\"/></td>");
					}
					ret.append("</tr></table></td></tr>");
				}
 */
				String email="";
				String fromEmail=mraldUser.getEmail();
				String emailParams = "?emailAddr=" + email + "&DataSet=" + fileName + "&sendFrom=" + fromEmail + "&comments=";

/* 				if (imgNames != null)
				{
					ret.append("\n<tr><td><table>");
					ret.append("\n<tr><td><form action=\"viewImage.jsp?imageFile=" + fileName + "\" target=\"_blank\" method=\"POST\"><input type=\"submit\" value=\"Viewer\" style=\""+ style_normal + "\"></input></form></td>");
					ret.append("<td><form action=\"ImageServer.jsp\"><input type=\"hidden\" name=\"fileName\" value=\"" +
		                 fileName + "\"></input><input name=\"fileAction\" type=\"submit\" value=\"download\" style=\""+ style_normal + "\"></form></td>");
					ret.append("<td><form action=\"emailForm.jsp" +emailParams + "\" target=\"_blank\" method=\"POST\"><input type=\"submit\" value=\"Request Original\" style=\""+ style_normal + "\"></input></form></td></tr>");
					ret.append("\n</table></td></tr>");

				}
 */
				//ret.append("<tr><td></td><td colspan=\"3\"><form action=\"ImageServer.jsp\"><input type=\"hidden\" name=\"fileName\" value=\"" +
                //        fileName + "\"></input><input name=\"fileAction\" type=\"submit\"  style=\""+ style_normal + "\" value=\"download\"></form><br></td></tr>");

			}

			retStart.append("<tr>");
            retStart.append("<td width=\"50%\" align=\"center\" colspan=\"2\"><b>There are " +
                    noOfImages + " images(s) associated with this Volume</b></td>");
            retStart.append("</tr>");
            retAll = retStart.toString() + ret.toString();

			return retAll;

		} catch (SQLException e)
		{
			throw new MraldException(e.getMessage());
		}

	}
}

