/*
 *  Copyright 2008 The MITRE Corporation (http://www.mitre.org/). All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.mitre.neuroWeb.taglib;
import java.net.URLEncoder;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;

import org.mitre.lattice.neuro.taglib.NeuroSpecificTag;
import org.mitre.mrald.util.MiscUtils;
import org.mitre.mrald.util.MraldException;
/**
 *  Description of the Class
 *
 *@author     ghamilton
 *@created    April 20, 2004
 */
public class VolumeDetailTag extends NeuroSpecificTag
{
	/**
	 *  Constructor for the VolumeDetailTag object
	 */
	public VolumeDetailTag()
	{
		super();
	}


	/**
	 *  Gets the query attribute of the MedicalTestResultTag object
	 *
	 *@return    The query value
	 */
	protected String[] getQuery()
	{

		String volumeID = pageContext.getRequest().getParameter("volume_id");
		volumeID =  MiscUtils.checkApostrophe(volumeID);

		String query = "SELECT volume.volume_id, volume.scan_id, modality, file_format, numerical_format, state, endianness, xdimension, ydimension, zdimension, " +
			" xfov, yfov, zfov, xorientation, yorientation, zorientation ,xresolution, yresolution, zresolution " +
			//" FROM volume LEFT OUTER JOIN images ON (volume.volume_id= images.volume_id) " +
			" FROM volume " +
			" WHERE volume.volume_id = '" + volumeID + "'" ;;

		String query2 = "SELECT  subject.subject_id " +
			" FROM subject, scan_event, volume " +
			" WHERE volume.volume_id = '" + volumeID + "'" +
			" AND scan_event.subject_id = subject.subject_id " +
			" AND volume.scan_id = scan_event.scan_id ";

		return new String[]{query, query2};
	}


	/**
	 *  Description of the Method
	 *
	 *@return    Description of the Return Value
	 */
	protected String init()
	{
		StringBuffer ret = new StringBuffer();
		ret.append("<table width=\"100%\" border=\"0\" cellspacing=\"1\" cellpadding=\"2\">");
		ret.append("<tr><th colspan=\"2\" style=\"letter-spacing:0.3em\">Volume Details</th></tr>");

		return ret.toString();
	}


	/**
	 *  Description of the Method
	 *
	 *@return    Description of the Return Value
	 */
	protected String endOutput()
	{
		return "</table>";
	}


	/**
	 *  Description of the Method
	 *
	 *@param  rs                  Description of the Parameter
	 *@return                     Description of the Return Value
	 *@exception  MraldException  Description of the Exception
	 */
	protected String processResultSet(ResultSet rs) throws MraldException
	{
		try
		{
			String subjID = pageContext.getRequest().getParameter("subject_id");

			String retAll = null;
			StringBuffer ret = new StringBuffer();
			StringBuffer retStart = new StringBuffer();
			int noOfVolume = 0;

			if (processCount == 1)
			{
				ResultSetMetaData rsmd = rs.getMetaData();
				int numberOfColumns = rsmd.getColumnCount();

				while (rs.next())
				{
					for (int i = 0; i < (numberOfColumns - 1); i++)
					{
						ret.append("<tr>");
						ret.append("<td width=\"50%\" align=\"right\"><b>" +
                            rsmd.getColumnLabel(i + 1) + ": </b></td>");
						ret.append("<td align=\"left\">" + rs.getString(i + 1) + "</td>");
						ret.append("</tr>");
					}
					noOfVolume++;


				}

				retStart.append("<tr>");
                retStart.append("<td width=\"50%\" align=\"center\" colspan=\"2\"><b>There are " +
                    noOfVolume + " volume(s) associated with this Subject</b></td>");
                retStart.append("</tr>");
				retAll = retStart.toString() + ret.toString();
			} else
			{
				String subj="";
				while (rs.next())
				{
					ret.append("<tr>");

					if (subjID == null)
					{
						subjID = rs.getString(1);
					}
					subj = subjID;
					if (subjID != null)
						subj = URLEncoder.encode(subjID, "UTF-8");


					ret.append("<td align=\"Right\"><b>Subject Detail</b></td><td width=\"50%\" align=\"left\"><a href=\"subject_info.jsp?subject_id=" + subj + "\">" + subjID + "</td>");
					ret.append("</tr>");
				}

				retAll = ret.toString();

			}


			return retAll;
		} catch (SQLException e)
		{
			throw new MraldException(e.getMessage());
		}
		catch (java.io.UnsupportedEncodingException e)
		{
			throw new MraldException(e.getMessage());
		}
	}
}

